<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateMail;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class MailLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 处理附件
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateMail::Enclosure] = Util::getFormatArray($row[TemplateMail::Enclosure]);
        $row[TemplateMail::Type] = (int)$row[TemplateMail::Type];
        $row[TemplateMail::MailType] = (int)$row[TemplateMail::MailType];
        if ($row[TemplateMail::ReplaceString] == "None") {
            $row[TemplateMail::ReplaceString] = array();
        } else {
            $row[TemplateMail::ReplaceString] = Util::getFormatArray3($row[TemplateMail::ReplaceString]);
        }
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_MAIL]
        );
    }
}
