<?php

namespace Tool\LoadTemplate\Logic;

use Tool\LoadTemplate\ILogic;
use Game\Constant\ConstTemplate\TemplateItem;

class ItemLogic extends ILogic
{
    /**
     * @param $row
     * @return bool
     * 处理数据 对UseId和TimeLimit字段检查
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateItem::ItemId] = (int)$row[TemplateItem::ItemId];
        $row[TemplateItem::UseType] = (int)$row[TemplateItem::UseType];
        $row[TemplateItem::TimeLimitType] = (int)$row[TemplateItem::TimeLimitType];
        $row[TemplateItem::ItemType] = (int)$row[TemplateItem::ItemType];
        $row[TemplateItem::ScoreNum] = (int)$row[TemplateItem::ScoreNum];

        $row[TemplateItem::IsStackabble] = $row[TemplateItem::IsStackabble] == 'True' ?? false;

        //处理使用类型
        switch ($row[TemplateItem::UseType])
        {
            case TemplateItem::USE_TYPE_NONE:
            case TemplateItem::USE_TYPE_JUMP_INTERFACE:
            case TemplateItem::USE_TYPE_OPEN_GIFT:
            case TemplateItem::USE_TYPE_USE_OPEN_SCENE:
                $row[TemplateItem::UseId] = (int)$row[TemplateItem::UseId];
                break;
            case TemplateItem::USE_TYPE_ACTIVATION_ITEM:
            case TemplateItem::USE_TYPE_ACTIVATION_CLOTH:
            case TemplateItem::USE_TYPE_UPDATE_VALUE:
            case TemplateItem::USE_TYPE_ACTIVATION_CAR_2_BAG:
            case TemplateItem::USE_TYPE_ACTIVATION_CAR_2_GARAGE:
            case TemplateItem::USE_TYPE_2_CAR_EXTERIOR:
                //分转秒
                $tmp = explode("*", $row[TemplateItem::UseId]);
                if (count($tmp) != 2) {
                    return false;
                }
                $tmp[1] = (int)$tmp[1] * 60;
                $row[TemplateItem::UseId] = $tmp;
                break;
            default:
                return false;
        }
        //处理使用期限

        switch ($row[TemplateItem::TimeLimitType])
        {
            case TemplateItem::TIME_LIMIT_TYPE_NONE:
                $row[TemplateItem::TimeLimit] = 0;
                break;
            case TemplateItem::TIME_LIMIT_TYPE_TIME_ADD:
                //分转秒
                $row[TemplateItem::TimeLimit] *= 60;
                break;
            case TemplateItem::TIME_LIMIT_TYPE_ACTIVITY_END:
                //天转秒
                $tmp = explode("*", $row[TemplateItem::TimeLimit]);
                if (count($tmp) == 2) {
                    //延长时间为天
                    $tmp[1] = (int)$tmp[1] * 24 * 3600;
                    $row[TemplateItem::TimeLimit] = $tmp;
                }
                break;
        }

        $row[TemplateItem::ConvertedId] = (int)$row[TemplateItem::ConvertedId];
        $row[TemplateItem::ConvertedCount] = (int)$row[TemplateItem::ConvertedCount];

        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}