<?php

/**
 * AI表
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateGuideAI;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class GuideAILogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateGuideAI::Sex] = (int)$row[TemplateGuideAI::Sex];
        $row[TemplateGuideAI::HeadModel] = (int)$row[TemplateGuideAI::HeadModel];
        $row[TemplateGuideAI::ClothData] = Util::getFormatArray3($row[TemplateGuideAI::ClothData]);
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_GUIDE_AI]
        );
    }
}
