<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateGrouping;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class GroupingLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    public function dealRow(&$row): bool
    {
        $row[TemplateGrouping::Type] = intval($row[TemplateGrouping::Type]);
        $row[TemplateGrouping::CarGroup] = Util::getFormatArrayToSemicolon($row[TemplateGrouping::CarGroup]);
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}
