<?php

/**
 * 道具商城
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateGoodsShop;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class GoodsShopLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateGoodsShop::UseType] = (int)$row[TemplateGoodsShop::UseType];
        $row[TemplateGoodsShop::ItemId] = (int)$row[TemplateGoodsShop::ItemId];
        $row[TemplateGoodsShop::Num] = (int)$row[TemplateGoodsShop::Num];
        $row[TemplateGoodsShop::ConvertedType] = (int)$row[TemplateGoodsShop::ConvertedType];
        $row[TemplateGoodsShop::Price] = (int)$row[TemplateGoodsShop::Price];
        $row[TemplateGoodsShop::ShowType] = (int)$row[TemplateGoodsShop::ShowType];
        $row[TemplateGoodsShop::MaxNum] = (int)$row[TemplateGoodsShop::MaxNum];
        //计算上下架时间
        $sTime = $eTime = 0;
        if (false == Util::StringToTime($row[TemplateGoodsShop::SDate]. " " .$row[TemplateGoodsShop::STime], $sTime)) {
            return false;
        }
        if (false == Util::StringToTime($row[TemplateGoodsShop::EDate]. " " .$row[TemplateGoodsShop::ETime], $eTime)) {
            return false;
        }
        $row[TemplateGoodsShop::StartTime] = $sTime;
        $row[TemplateGoodsShop::EndTime] = $eTime;
        //计算真实价格 价格*折扣
        if ($row[TemplateGoodsShop::Discount] == "0") {
            $row[TemplateGoodsShop::RealPrice] = $row[TemplateGoodsShop::Price];
        } else {
            $row[TemplateGoodsShop::RealPrice] = $row[TemplateGoodsShop::Price] * (int)$row[TemplateGoodsShop::Discount] / 100;
        }
        return true;
    }
}
