<?php

namespace Tool\LoadTemplate\Logic;

use Tool\LoadTemplate\ILogic;
use Game\Constant\ConstTemplate\TemplateGiftPack;
use Tool\LoadTemplate\Util;

class GiftPackLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 礼包道具内容,暂时转为array(itemid=>num),需要做此功能时,根据自己习惯修改
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateGiftPack::Id] = (int)$row[TemplateGiftPack::Id];
        $row[TemplateGiftPack::UseType] = (int)$row[TemplateGiftPack::UseType];
        $row[TemplateGiftPack::Numb] = (int)$row[TemplateGiftPack::Numb];
        $row[TemplateGiftPack::Item] = Util::getStr3FormatArray($row[TemplateGiftPack::Item]);
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}