<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateGenerateAi;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class GenerateAiLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    public function dealRow(&$row): bool
    {
        $row[TemplateGenerateAi::Car] = Util::getFormatArrayToSemicolon($row[TemplateGenerateAi::Car]);
        $row[TemplateGenerateAi::CarLevel] = Util::getFormatArrayToSemicolon($row[TemplateGenerateAi::CarLevel]);
        $row[TemplateGenerateAi::Strengthen] = Util::getFormatArrayToSemicolon($row[TemplateGenerateAi::Strengthen]);
        $row[TemplateGenerateAi::AIIds] = Util::getFormatArrayToSemicolon($row[TemplateGenerateAi::AIIds]);
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_GENERATE_AI]
        );
    }
}
