<?php

namespace Tool\LoadTemplate\Logic;

use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateClothing;
use Game\Constant\ConstTemplate\TemplateCreateRole;
use Game\Constant\ConstTemplate\TemplateItem;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class CreateRoleLogic extends ILogic
{
    use TemplateHelp;

    /**
     * @param $row
     * @return bool
     * 整理货币,道具等信息
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateCreateRole::Id] = (int)$row[TemplateCreateRole::Id];
        $row[TemplateCreateRole::Gender] = (int)$row[TemplateCreateRole::Gender];

        //初始道具
        $row[TemplateCreateRole::InitialItem] = Util::getFormatArray($row[TemplateCreateRole::InitialItem]);
        //检查整理服装
        $maleCloth = array();
        $femaleCloth = array();
        //初始道具相关
        $clothScore = 0;
        $initMoney = array();
        $initCar = array();
        $initItem = array();    //除上述类型外的道具
        foreach ($row[TemplateCreateRole::InitialItem] as $itemId => $num) {
            $configItemData = $this->getTitle( TemplateDefine::TYPE_ITEM, $itemId);
            if (is_null($configItemData)) {
                return false;
            }
            switch($configItemData[TemplateItem::ItemType]) {
                case TemplateItem::ITEM_TYPE_CAR :
                    //转成对应CarId=>过期时间
                    $initCar[$itemId] = $configItemData[TemplateItem::UseId];
                    break;
                case TemplateItem::ITEM_TYPE_CLOTH:
                    $configClothingData = $this->getTitle( TemplateDefine::TYPE_CLOTHING, $itemId);
                    if (!is_null($configClothingData)) {
                        //根据服装位置和性别,更新服装信息
                        if ($configClothingData[TemplateClothing::Sex] == 1) {
                            $maleCloth[$configClothingData[TemplateClothing::Part]] = $itemId;
                        } else {
                            $femaleCloth[$configClothingData[TemplateClothing::Part]] = $itemId;
                        }
                        $initItem[$itemId] = $num;
                        $clothScore += $configItemData[TemplateItem::ScoreNum];
                    }
                    break;
                case TemplateItem::ITEM_TYPE_MONEY:
                    $initMoney[$itemId] = $num;
                    break;
                default:
                    $initItem[$itemId] = $num;
                    break;
            }
        }
        $row[TemplateCreateRole::InitClothMale] = $maleCloth;
        $row[TemplateCreateRole::InitClothFemale] = $femaleCloth;
        $row[TemplateCreateRole::ClothScore] = $clothScore;
        $row[TemplateCreateRole::InitMoney] = $initMoney;
        $row[TemplateCreateRole::InitCar] = $initCar;
        $row[TemplateCreateRole::InitItem] = $initItem;
        return true;
    }
}
