<?php

namespace Tool\LoadTemplate\Logic;

use Tool\LoadTemplate\ILogic;
use Game\Constant\ConstTemplate\TemplateConst;

class ConstLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 处理数据
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateConst::ConstNum] = (int)$row[TemplateConst::ConstNum];
        $row[TemplateConst::ConstId] = (int)$row[TemplateConst::ConstId];
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_15_MailExpireTime)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] * 24 * 3600;
        }
        //比赛结算奖励--蓝图和碎片概率
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Match_Settlement_BluePrint_Rate)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] / 100;
        }
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Match_Settlement_Chip_Rate)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] / 100;
        }
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Scuffle_Score_Discount)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] / 1000;
        }
        //时间 小时转秒
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Intimacy_Remove_Title_CD_Time)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] * 3600;
        }
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Intimacy_Remove_Title_Invalid_Time)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] * 3600;
        }
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Intimacy_Apply_Live_Time)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] * 3600;
        }
        //排位分加权 /100
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Ranking_Score_Avg_2_Max)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] / 100;
        }
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Ranking_Score_Avg_2_Min)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] / 100;
        }
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Ranking_Score_Avg_3_Max)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] / 100;
        }
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Ranking_Score_Avg_3_Mid)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] / 100;
        }
        if (($row[TemplateConst::ConstId] == TemplateConst::Const_Ranking_Score_Avg_3_Min)) {
            $row[TemplateConst::ConstNum] = $row[TemplateConst::ConstNum] / 100;
        }
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}