<?php

namespace Tool\LoadTemplate\Logic;

use Tool\LoadTemplate\ILogic;
use Game\Constant\ConstTemplate\TemplateCompetitionMode;

class CompetitionModeLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 处理数据 对UseId和TimeLimit字段检查
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateCompetitionMode::RoomMax] = (int)$row[TemplateCompetitionMode::RoomMax];
        $row[TemplateCompetitionMode::OpenIf] = (int)$row[TemplateCompetitionMode::OpenIf];
        $row[TemplateCompetitionMode::WhetherExp] = (int)$row[TemplateCompetitionMode::WhetherExp];
        $row[TemplateCompetitionMode::WhetherPro] = (int)$row[TemplateCompetitionMode::WhetherPro];
        //处理奖励
        [$flag, $reward] = $this->dealReward($row[TemplateCompetitionMode::VictoryRewardItem]);
        if (!$flag) {
            return false;
        }
        $row[TemplateCompetitionMode::VictoryRewardItem] = $reward;

        [$flag, $reward] = $this->dealReward($row[TemplateCompetitionMode::FailRewardItem]);
        if (!$flag) {
            return false;
        }
        $row[TemplateCompetitionMode::FailRewardItem] = $reward;
        return true;
    }

    private function dealReward(string $rewardString): array
    {
        if ($rewardString == "None") {
            return array(
                true, array()
            );
        }
        $tmp = explode(";",$rewardString);
        $arr = [];
        foreach ($tmp as $k => $v) {
            $t = explode("*", $v);
            if (count($t) != 3) {
                return array(false, array());
            }
            $arr[$k][TemplateCompetitionMode::REWARD_ID] = (int)$t[0];
            $arr[$k][TemplateCompetitionMode::REWARD_NUM] = (int)$t[1];
            $arr[$k][TemplateCompetitionMode::REWARD_RATIO] = (float)$t[2];
        }
        return array(true, $arr);
    }
}