<?php

/**
 * 服装
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Game\Constant\ConstTemplate\TemplateClothing;

class ClothingLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 整理货币,道具等信息
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateClothing::Id] = (int)$row[TemplateClothing::Id];
        $row[TemplateClothing::SuitID] = (int)$row[TemplateClothing::SuitID];
        $row[TemplateClothing::Sex] = (int)$row[TemplateClothing::Sex];
        $row[TemplateClothing::Part] = (int)$row[TemplateClothing::Part];
        //互斥部位
        $row[TemplateClothing::MutuallyExclusiveParts] = $row[TemplateClothing::MutuallyExclusiveParts] == "None" ?
        0 : (int)$row[TemplateClothing::MutuallyExclusiveParts];
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_CLOTHING]
        );
    }
}
