<?php
/**
 * 关卡章节奖励领取
 * @date 2022/5/12
 * @author JZW
 **/

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateChapterReward;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ChapterRewardLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title[$key] = $val;
        return true;
    }

    public function dealRow(&$row): bool
    {
        $row[TemplateChapterReward::Reward] = Util::getFormatArray($row[TemplateChapterReward::Reward]);
        $row[TemplateChapterReward::Number] = (int)$row[TemplateChapterReward::Number];
        $row[TemplateChapterReward::Chapter] = (int)$row[TemplateChapterReward::Chapter];
        return true;
    }
}