<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateChallengeTask;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ChallengeTaskLogic extends ILogic
{
    private array $mapList = array();

    public function dealRow(&$row): bool
    {
        $row[TemplateChallengeTask::Id] = (int)$row[TemplateChallengeTask::Id];
        $row[TemplateChallengeTask::ChallengeMap] = (int)$row[TemplateChallengeTask::ChallengeMap];
        $row[TemplateChallengeTask::Target] = (int)$row[TemplateChallengeTask::Target];
        $row[TemplateChallengeTask::Reward] = Util::getFormatArray($row[TemplateChallengeTask::Reward]);
        //整理地图
        $this->mapList[$row[TemplateChallengeTask::ChallengeMap]][$row[TemplateChallengeTask::Id]] = $row;
        return true;
    }

    public function dealFile(&$file): bool
    {
        $file = $this->mapList;
        return true;
    }
}
