<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateCarAggrandizement;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class CarAggrandizementLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 处理数据
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateCarAggrandizement::BoostCurrencyConsumption] = Util::getFormatArray($row[TemplateCarAggrandizement::BoostCurrencyConsumption]);
        $row[TemplateCarAggrandizement::BoostItemConsumption] = Util::getFormatArray($row[TemplateCarAggrandizement::BoostItemConsumption]);
        $row[TemplateCarAggrandizement::BounsItems] = Util::getFormatArray($row[TemplateCarAggrandizement::BounsItems]);
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}