<?php

/**
 * 活动时间
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateActivityTime;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ActivityTimeLogic extends ILogic
{
    private array $activityArray = array();

    public function dealRow(&$row): bool
    {
        $row[TemplateActivityTime::Activity] = (int)$row[TemplateActivityTime::Activity];
        $row[TemplateActivityTime::ActivityId] = (int)$row[TemplateActivityTime::ActivityId];
        $row[TemplateActivityTime::TimeType] = (int)$row[TemplateActivityTime::TimeType];
        $row[TemplateActivityTime::TimeGap] = (int)$row[TemplateActivityTime::TimeGap];
        switch ($row[TemplateActivityTime::TimeType])
        {
            case TemplateActivityTime::TIME_TYPE_1:
                //根据开始时间和持续时间,计算开始结束时间
                $sTime = $eTime = 0;
                if (false == Util::StringToTime($row[TemplateActivityTime::TimeParameter], $sTime)) {
                    return false;
                }
                $eTime = $sTime + 24 * 3600 * $row[TemplateActivityTime::TimeGap];
                $row[TemplateActivityTime::StartTime] = $sTime;
                $row[TemplateActivityTime::EndTime] = $eTime;
                break;
            case TemplateActivityTime::TIME_TYPE_2:
                //固定周开启
                $row[TemplateActivityTime::TimeParameter] = Util::getFormatArrayToSemicolon($row[TemplateActivityTime::TimeParameter]);
                break;
            default:
                return false;

        }
        $this->activityArray[$row[TemplateActivityTime::Activity]][$row[TemplateActivityTime::ActivityId]] = $row;
        return true;
    }

    public function dealFile(&$file): bool
    {
        $file = $this->activityArray;
        return true;
    }
}
