<?php

/**
 * Logic.php
 * 文件描述
 * Created On 2022/1/17
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Tool\LoadTemplate;

use Game\Constant\TemplateDefine;

class Logic
{
    use Log;

    private ?ILogic $logic;

    public function cleanUp()
    {
        unset($this->logic);
        $this->logic = null;
    }

    public function dealKey($key, $val, &$title): bool
    {
        if ($this->logic != null) {
            return $this->logic->DealKey($key, $val, $title);
        }
        $title[$key] = $val;
        return true;
    }

    public function dealRow(&$row): bool
    {
        if ($this->logic != null) {
            return $this->logic->DealRow($row);
        }
        return true;
    }

    public function dealFile(&$file): bool
    {
        if ($this->logic != null) {
            return $this->logic->DealFile($file);
        }
        return true;
    }

    public function init($type)
    {
        if (!array_key_exists($type, Config::LOGIC_DEFINE)) {
            return;
        }
        $name = Config::LOGIC_DEFINE[$type];
        $this->logic = new $name();
    }

    public function getTidyList(): array
    {
        if ($this->logic != null) {
            return $this->logic->GetTidyList();
        }
        return array();
    }
}
