<?php

/**
 * LoadSingle.php
 * 文件描述
 * Created On 2022/1/17
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Tool\LoadTemplate;

class LoadSingle
{
    use Log;

    private string $filePath;

    private array $keyList;

    private array $context;

    private array $define;

    private Logic $logic;

    public function cleanUp()
    {
        $this->filePath = "";

        unset($this->keyList);
        $this->keyList = array();

        unset($this->context);
        $this->context = array();

        unset($this->define);
        $this->define = array();
    }

    public function getContext(): array
    {
        return $this->context;
    }

    public function load($filePath, $logic, $define): bool
    {
        $this->filePath = $filePath;
        $this->logic = $logic;
        $this->define = $define;

        $handler = fopen($filePath, "r");
        if ($handler == false) {
            $log = sprintf("file[%s] open fail", $filePath);
            $this->addError($log);
            return false;
        }
        $index = 0;
        while (($buffer = fgets($handler, 4096)) !== false) {
            if ($index == 0) {
                $BOM = chr(239) . chr(187) . chr(191);
                $buffer = str_replace($BOM, '', $buffer);
            }
            $buffer = trim($buffer, "\n\r");
            if ($buffer == "") {
                continue;
            }
            if ($index == 0) {
                $this->keyList = explode("\t", $buffer);
            } elseif ($this->loadTitle($buffer) == false) {
                return false;
            }
            ++$index;
        }
        if (!feof($handler)) {
            $log = sprintf("file[%s] read fnof fail", $filePath);
            $this->addError($log);
            return false;
        }
        fclose($handler);
        if ($logic->DealFile($this->context) == false) {
            $log = sprintf("file[%s] logic deal file fail", $filePath);
            $this->addError($log);
            return false;
        }
        return true;
    }

    private function loadTitle($buffer): bool
    {
        if ($buffer == "") {
            return true;
        }
        if ($buffer == null) {
            return true;
        }
        $tmp = explode("\t", $buffer);
        $len = count($this->keyList);
        if ($len != count($tmp)) {
            $log = sprintf("data[%s] len[%d] not match key[%d] len", $buffer, count($tmp), $len);
            $this->addError($log);
            return false;
        }
        $title = array();
        $key = "";
        for ($i = 0; $i < $len; $i++) {
            if ($i == 0) {
                $key = $tmp [0];
                if ($key == "") {
                    return true;
                }
            }
            if (!in_array($this->keyList [$i], $this->define)) {
                continue;
            }
            if ($this->logic->DealKey($this->keyList [$i], $tmp [$i], $title) == false) {
                $log = sprintf(
                    "table[%s] id[%s] deal key[%s] val[%s] error ",
                    $this->filePath,
                    $key,
                    $this->keyList[$i],
                    $tmp[$i]
                );
                $this->addError($log);
                unset($title);
                return false;
            }
        }
        if (!$this->logic->DealRow($title)) {
            $log = sprintf("table[%s] id[%s] deal row[%s] error ", $this->filePath, $key, $buffer);
            $this->addError($log);
            unset($title);
            return false;
        }
        if (array_key_exists($key, $this->context)) {
            $log = sprintf("table[%s] id[%s] has exist ", $this->filePath, $key);
            $this->addError($log);
            unset($title);
            return false;
        }
        $this->context [$key] = $title;
        unset($title);
        return true;
    }
}
