<?php

/**
 * Config.php
 * 文件描述
 * Created On 2022/1/17
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Tool\LoadTemplate;

use Game\Constant\TemplateDefine;

class Config
{
    //TXT文件位置
    public const DATA_PATH = __DIR__ . "/../../Table/";

    //GameTable下txt文件名
    public const FILE_LIST = array(
        TemplateDefine::TYPE_ITEM => "Item",
        TemplateDefine::TYPE_PAIWEI_LEVEL => "Levelform",
        TemplateDefine::TYPE_INTEGRAL => "Integralform",
        TemplateDefine::TYPE_GIFT_PACK => "GiftPack",
        TemplateDefine::TYPE_CONST => "ConstForm",
        TemplateDefine::TYPE_CLOTHING => "Clothing",
        TemplateDefine::TYPE_CREATE_ROLE => "Createrole",
        TemplateDefine::TYPE_MAIL => "Mailbox",
        TemplateDefine::TYPE_CAR => "Car",
        TemplateDefine::TYPE_CAR_AGGRANDIZEMENT => "CarAggrandizement",
        TemplateDefine::TYPE_PROFICIENCY_CAR => "ProficientCar",
        TemplateDefine::TYPE_RANDOM_ID => "RandomID",
        TemplateDefine::TYPE_DEEPMOD => "Deepmod",
        TemplateDefine::TYPE_MATCH_TIME => "Matchtime",
        TemplateDefine::TYPE_TASK => "Task",
        TemplateDefine::TYPE_DAILY_TASK_REWARD => "EverydayReward",
        TemplateDefine::TYPE_ZL_REWARD => "ScheduleReward",
        TemplateDefine::TYPE_TALE => "Tale",
        TemplateDefine::TYPE_PVP_MAP => "PVP",
        TemplateDefine::TYPE_COMPETITION_MODE => "CompetitionMode",
        TemplateDefine::TYPE_CHAPTER_REWARD => "TaleReward",
        TemplateDefine::TYPE_APPEARANCE => "Appearance",
        TemplateDefine::TYPE_NUMBER => "Number",
        TemplateDefine::TYPE_SHIELD_NUMBER => "ShieldNumber",
        TemplateDefine::TYPE_REFIT => "Refit",
        TemplateDefine::TYPE_CLUB_STORE => "ClubStore",
        TemplateDefine::TYPE_CLUB_SCHEDULE_REWARD => "ClubScheduleReward",
        TemplateDefine::TYPE_CLUB_LEVEL => "ClubLevel",
        TemplateDefine::TYPE_GROUPING => "Grouping",
        TemplateDefine::TYPE_GENERATE_AI => "GenerateAi",
        TemplateDefine::TYPE_PVP_MATCH => "PVPMatch",
        TemplateDefine::TYPE_SHOP_ITEM => "GoodsShop",
        TemplateDefine::TYPE_SHOP_CAR => "ShopCar",
        TemplateDefine::TYPE_PROFICIENCY_TOTAL => "Proficient",
        TemplateDefine::TYPE_CHALLENGE_TIME => "ChallengeTime",
        TemplateDefine::TYPE_CHALLENGE_TASK => "ChallengeTask",
        TemplateDefine::TYPE_SHOP_CLOTHING => "ShopClothing",
        TemplateDefine::TYPE_SEASON_REWARD => "SeasonReward",
        TemplateDefine::TYPE_SEASON_REWARD_CONDITION => "SeasonRewardCondition",
        TemplateDefine::TYPE_ACTIVITY_TIME => "ActivityTime",
        TemplateDefine::TYPE_SCUFFLE_CAR => "ScrimmageCar",
        TemplateDefine::TYPE_SCUFFLE_TITLE => "ScrimmageTitle",
        TemplateDefine::TYPE_SHOP_SEASON => "ShopSeason",
        TemplateDefine::TYPE_ACTIVITY_WELFARE => "ActivityWelfare",
        TemplateDefine::TYPE_SHIELD_WORDS => "Shieldwords",
        TemplateDefine::TYPE_SCUFFLE_SCORE => "RandomIntegral",
        TemplateDefine::TYPE_SHOP_ZL => "ShopBP",
        TemplateDefine::TYPE_INTIMACY => "Intimacy",
        TemplateDefine::TYPE_INTIMACY_REWARD => "IntimaciesReward",
        TemplateDefine::TYPE_PLAYER_LEVEL => "LevelTask",
        TemplateDefine::TYPE_PLAYER_HEAD_MODEL => "HeadModel",
        TemplateDefine::TYPE_SHOP_RECOMMEND => "ShopRECO",
        TemplateDefine::TYPE_SHOP_BLIND_BOX => "ShopBox",
        TemplateDefine::TYPE_BLIND_BOX => "ItemBox",
        TemplateDefine::TYPE_SHOP_EXCHANGE => "ShopExchange",
        TemplateDefine::TYPE_TASK_EXCHANGE => "TaskExchange",
        TemplateDefine::TYPE_TASK_LOGIN => "TaskLogin",
        TemplateDefine::TYPE_TASK_TARGET => "TaskAim",
        TemplateDefine::TYPE_TASK_FESTIVAL => "TaskFestival",
        TemplateDefine::TYPE_RANK_ACTIVE => "RankActive",
        TemplateDefine::TYPE_RANK_STRAIGHT_WIN => "RankStraightWin",
        TemplateDefine::TYPE_RANK_WIN_RATIO => "RankWinRatio",
        TemplateDefine::TYPE_RANK_TEAM_POSITION => "RankPosition",
        TemplateDefine::TYPE_RANK_MATCH => "RankMatch",
        TemplateDefine::TYPE_RANKING_TEST => "RankingTest",
        TemplateDefine::TYPE_LICENSE_REWARD => "LicenseReward",
        TemplateDefine::TYPE_SKIN_ATTRIBUTION => "SkinAttribution",
        TemplateDefine::TYPE_AI => "AI",
        TemplateDefine::TYPE_GUIDE_AI => "NoviceRole",
    );

    //模板
    public const TEMPLATE_LIST = array(
        TemplateDefine::TYPE_ITEM => 'Game\Constant\ConstTemplate\TemplateItem',
        TemplateDefine::TYPE_PAIWEI_LEVEL => 'Game\Constant\ConstTemplate\TemplateLevel',
        TemplateDefine::TYPE_INTEGRAL => 'Game\Constant\ConstTemplate\TemplateIntegral',
        TemplateDefine::TYPE_GIFT_PACK => 'Game\Constant\ConstTemplate\TemplateGiftPack',
        TemplateDefine::TYPE_CONST => 'Game\Constant\ConstTemplate\TemplateConst',
        TemplateDefine::TYPE_INIT_PLAYER => 'Game\Constant\ConstTemplate\TemplateInitPlayer',
        TemplateDefine::TYPE_CREATE_ROLE => 'Game\Constant\ConstTemplate\TemplateCreateRole',
        TemplateDefine::TYPE_CLOTHING => 'Game\Constant\ConstTemplate\TemplateClothing',
        TemplateDefine::TYPE_MAIL => 'Game\Constant\ConstTemplate\TemplateMail',
        TemplateDefine::TYPE_CAR => 'Game\Constant\ConstTemplate\TemplateCar',
        TemplateDefine::TYPE_CAR_AGGRANDIZEMENT => 'Game\Constant\ConstTemplate\TemplateCarAggrandizement',
        TemplateDefine::TYPE_RANDOM_ID => 'Game\Constant\ConstTemplate\TemplateRandomId',
        TemplateDefine::TYPE_PROFICIENCY_CAR => 'Game\Constant\ConstTemplate\TemplateProficiency',
        TemplateDefine::TYPE_DEEPMOD => 'Game\Constant\ConstTemplate\TemplateCarDeepmod',
        TemplateDefine::TYPE_MATCH_TIME => 'Game\Constant\ConstTemplate\TemplateMatchTime',
        TemplateDefine::TYPE_TASK => 'Game\Constant\ConstTemplate\TemplateTask',
        TemplateDefine::TYPE_DAILY_TASK_REWARD => 'Game\Constant\ConstTemplate\TemplateDailyReward',
        TemplateDefine::TYPE_ZL_REWARD => 'Game\Constant\ConstTemplate\TemplateZLReward',
        TemplateDefine::TYPE_PVP_MAP => 'Game\Constant\ConstTemplate\TemplatePVPMap',
        TemplateDefine::TYPE_COMPETITION_MODE => 'Game\Constant\ConstTemplate\TemplateCompetitionMode',
        TemplateDefine::TYPE_TALE => 'Game\Constant\ConstTemplate\TemplateTale',
        TemplateDefine::TYPE_CHAPTER_REWARD => 'Game\Constant\ConstTemplate\TemplateChapterReward',
        TemplateDefine::TYPE_APPEARANCE => 'Game\Constant\ConstTemplate\TemplateAppearance',
        TemplateDefine::TYPE_NUMBER => 'Game\Constant\ConstTemplate\TemplateNumber',
        TemplateDefine::TYPE_SHIELD_NUMBER => 'Game\Constant\ConstTemplate\TemplateShieldNumber',
        TemplateDefine::TYPE_REFIT => 'Game\Constant\ConstTemplate\TemplateRefit',
        TemplateDefine::TYPE_CLUB_STORE => 'Game\Constant\ConstTemplate\TemplateClubStore',
        TemplateDefine::TYPE_CLUB_SCHEDULE_REWARD => 'Game\Constant\ConstTemplate\TemplateClubScheduleReward',
        TemplateDefine::TYPE_CLUB_LEVEL => 'Game\Constant\ConstTemplate\TemplateClubLevel',
        TemplateDefine::TYPE_GROUPING => 'Game\Constant\ConstTemplate\TemplateGrouping',
        TemplateDefine::TYPE_GENERATE_AI => 'Game\Constant\ConstTemplate\TemplateGenerateAi',
        TemplateDefine::TYPE_PVP_MATCH => 'Game\Constant\ConstTemplate\TemplatePVPMatch',
        TemplateDefine::TYPE_SHOP_ITEM => 'Game\Constant\ConstTemplate\TemplateGoodsShop',
        TemplateDefine::TYPE_PROFICIENCY_TOTAL => 'Game\Constant\ConstTemplate\TemplateTotalProficiency',
        TemplateDefine::TYPE_SHOP_CAR => 'Game\Constant\ConstTemplate\TemplateShopCar',
        TemplateDefine::TYPE_CHALLENGE_TIME => 'Game\Constant\ConstTemplate\TemplateChallengeTime',
        TemplateDefine::TYPE_CHALLENGE_TASK => 'Game\Constant\ConstTemplate\TemplateChallengeTask',
        TemplateDefine::TYPE_SHOP_CLOTHING => 'Game\Constant\ConstTemplate\TemplateShopClothing',
        TemplateDefine::TYPE_SEASON_REWARD => 'Game\Constant\ConstTemplate\TemplateSeasonReward',
        TemplateDefine::TYPE_SEASON_REWARD_CONDITION => 'Game\Constant\ConstTemplate\TemplateSeasonRewardCondition',
        TemplateDefine::TYPE_ACTIVITY_TIME => 'Game\Constant\ConstTemplate\TemplateActivityTime',
        TemplateDefine::TYPE_SCUFFLE_CAR => 'Game\Constant\ConstTemplate\TemplateScrimmageCar',
        TemplateDefine::TYPE_SCUFFLE_TITLE => 'Game\Constant\ConstTemplate\TemplateScrimmageTitle',
        TemplateDefine::TYPE_SHOP_SEASON => 'Game\Constant\ConstTemplate\TemplateSeasonStore',
        TemplateDefine::TYPE_ACTIVITY_WELFARE => 'Game\Constant\ConstTemplate\TemplateActivityWelfare',
        TemplateDefine::TYPE_SHIELD_WORDS => 'Game\Constant\ConstTemplate\TemplateShieldWords',
        TemplateDefine::TYPE_SCUFFLE_SCORE => 'Game\Constant\ConstTemplate\TemplateScuffleScore',
        TemplateDefine::TYPE_SHOP_ZL => 'Game\Constant\ConstTemplate\TemplateBPStore',
        TemplateDefine::TYPE_INTIMACY => 'Game\Constant\ConstTemplate\TemplateIntimacy',
        TemplateDefine::TYPE_INTIMACY_REWARD => 'Game\Constant\ConstTemplate\TemplateIntimacyReward',
        TemplateDefine::TYPE_PLAYER_LEVEL => 'Game\Constant\ConstTemplate\TemplatePlayerLevel',
        TemplateDefine::TYPE_PLAYER_HEAD_MODEL => 'Game\Constant\ConstTemplate\TemplateHeadModel',
        TemplateDefine::TYPE_SHOP_RECOMMEND => 'Game\Constant\ConstTemplate\TemplateShopRecommend',
        TemplateDefine::TYPE_SHOP_BLIND_BOX => 'Game\Constant\ConstTemplate\TemplateShopBlindBox',
        TemplateDefine::TYPE_BLIND_BOX => 'Game\Constant\ConstTemplate\TemplateBlindBox',
        TemplateDefine::TYPE_SHOP_EXCHANGE => 'Game\Constant\ConstTemplate\TemplateShopExchange',
        TemplateDefine::TYPE_TASK_EXCHANGE => 'Game\Constant\ConstTemplate\TemplateTaskExchange',
        TemplateDefine::TYPE_TASK_LOGIN => 'Game\Constant\ConstTemplate\TemplateTaskLogin',
        TemplateDefine::TYPE_TASK_TARGET => 'Game\Constant\ConstTemplate\TemplateTaskTarget',
        TemplateDefine::TYPE_TASK_FESTIVAL => 'Game\Constant\ConstTemplate\TemplateTaskFestival',
        TemplateDefine::TYPE_RANK_ACTIVE => 'Game\Constant\ConstTemplate\TemplateRankActive',
        TemplateDefine::TYPE_RANK_STRAIGHT_WIN => 'Game\Constant\ConstTemplate\TemplateRankStraightWin',
        TemplateDefine::TYPE_RANK_WIN_RATIO => 'Game\Constant\ConstTemplate\TemplateRankWinRatio',
        TemplateDefine::TYPE_RANK_TEAM_POSITION => 'Game\Constant\ConstTemplate\TemplateRankPosition',
        TemplateDefine::TYPE_RANK_MATCH => 'Game\Constant\ConstTemplate\TemplateRankMatch',
        TemplateDefine::TYPE_RANKING_TEST => 'Game\Constant\ConstTemplate\TemplateRankingTest',
        TemplateDefine::TYPE_LICENSE_REWARD => 'Game\Constant\ConstTemplate\TemplateLicenseReward',
        TemplateDefine::TYPE_SKIN_ATTRIBUTION => 'Game\Constant\ConstTemplate\TemplateSkinAttribution',
        TemplateDefine::TYPE_AI => 'Game\Constant\ConstTemplate\TemplateAI',
        TemplateDefine::TYPE_GUIDE_AI => 'Game\Constant\ConstTemplate\TemplateGuideAI',
        TemplateDefine::TYPE_UID_INDEX => 'Game\Constant\ConstTemplate\TemplateUidIndex',
    );

    public static function getTemplateName($type): ?string
    {
        return self::TEMPLATE_LIST[$type] ?? "";
    }

    //模板处理逻辑
    public const LOGIC_DEFINE = array(
        TemplateDefine::TYPE_ITEM => 'Tool\LoadTemplate\Logic\ItemLogic',
        TemplateDefine::TYPE_PAIWEI_LEVEL => 'Tool\LoadTemplate\Logic\LevelLogic',
        TemplateDefine::TYPE_INTEGRAL => 'Tool\LoadTemplate\Logic\IntegralLogic',
        TemplateDefine::TYPE_GIFT_PACK => 'Tool\LoadTemplate\Logic\GiftPackLogic',
        TemplateDefine::TYPE_CONST => 'Tool\LoadTemplate\Logic\ConstLogic',
        TemplateDefine::TYPE_CREATE_ROLE => 'Tool\LoadTemplate\Logic\CreateRoleLogic',
        TemplateDefine::TYPE_CLOTHING => 'Tool\LoadTemplate\Logic\ClothingLogic',
        TemplateDefine::TYPE_MAIL => 'Tool\LoadTemplate\Logic\MailLogic',
        TemplateDefine::TYPE_CAR => 'Tool\LoadTemplate\Logic\CarLogic',
        TemplateDefine::TYPE_CAR_AGGRANDIZEMENT => 'Tool\LoadTemplate\Logic\CarAggrandizementLogic',
        TemplateDefine::TYPE_RANDOM_ID => 'Tool\LoadTemplate\Logic\RandomIdLogic',
        TemplateDefine::TYPE_PROFICIENCY_CAR => 'Tool\LoadTemplate\Logic\ProficiencyLogic',
        TemplateDefine::TYPE_DEEPMOD => 'Tool\LoadTemplate\Logic\DeepmodLogic',
        TemplateDefine::TYPE_MATCH_TIME => 'Tool\LoadTemplate\Logic\MatchTimeLogic',
        TemplateDefine::TYPE_PVP_MAP => 'Tool\LoadTemplate\Logic\PVPMapLogic',
        TemplateDefine::TYPE_COMPETITION_MODE => 'Tool\LoadTemplate\Logic\CompetitionModeLogic',
        TemplateDefine::TYPE_TASK => 'Tool\LoadTemplate\Logic\TaskLogic',
        TemplateDefine::TYPE_DAILY_TASK_REWARD => 'Tool\LoadTemplate\Logic\DailyRewardLogic',
        TemplateDefine::TYPE_ZL_REWARD => 'Tool\LoadTemplate\Logic\ZLRewardLogic',
        TemplateDefine::TYPE_TALE => 'Tool\LoadTemplate\Logic\TaleLogic',
        TemplateDefine::TYPE_CHAPTER_REWARD => 'Tool\LoadTemplate\Logic\ChapterRewardLogic',
        TemplateDefine::TYPE_APPEARANCE => 'Tool\LoadTemplate\Logic\AppearanceLogic',
        TemplateDefine::TYPE_NUMBER => 'Tool\LoadTemplate\Logic\NumberLogic',
        TemplateDefine::TYPE_SHIELD_NUMBER => 'Tool\LoadTemplate\Logic\ShieldNumberLogic',
        TemplateDefine::TYPE_REFIT => 'Tool\LoadTemplate\Logic\RefitLogic',
        TemplateDefine::TYPE_CLUB_STORE => 'Tool\LoadTemplate\Logic\ClubStoreLogic',
        TemplateDefine::TYPE_CLUB_SCHEDULE_REWARD => 'Tool\LoadTemplate\Logic\ClubScheduleRewardLogic',
        TemplateDefine::TYPE_CLUB_LEVEL => 'Tool\LoadTemplate\Logic\ClubLevelLogic',
        TemplateDefine::TYPE_GROUPING => 'Tool\LoadTemplate\Logic\GroupingLogic',
        TemplateDefine::TYPE_GENERATE_AI => 'Tool\LoadTemplate\Logic\GenerateAiLogic',
        TemplateDefine::TYPE_PVP_MATCH => 'Tool\LoadTemplate\Logic\PVPMatchLogic',
        TemplateDefine::TYPE_SHOP_ITEM => 'Tool\LoadTemplate\Logic\GoodsShopLogic',
        TemplateDefine::TYPE_PROFICIENCY_TOTAL => 'Tool\LoadTemplate\Logic\TotalProficiencyLogic',
        TemplateDefine::TYPE_SHOP_CAR => 'Tool\LoadTemplate\Logic\ShopCarLogic',
        TemplateDefine::TYPE_CHALLENGE_TIME => 'Tool\LoadTemplate\Logic\ChallengeTimeLogic',
        TemplateDefine::TYPE_CHALLENGE_TASK => 'Tool\LoadTemplate\Logic\ChallengeTaskLogic',
        TemplateDefine::TYPE_SHOP_CLOTHING => 'Tool\LoadTemplate\Logic\ShopClothingLogic',
        TemplateDefine::TYPE_SEASON_REWARD => 'Tool\LoadTemplate\Logic\SeasonRewardLogic',
        TemplateDefine::TYPE_SEASON_REWARD_CONDITION => 'Tool\LoadTemplate\Logic\SeasonRewardConditionLogic',
        TemplateDefine::TYPE_ACTIVITY_TIME => 'Tool\LoadTemplate\Logic\ActivityTimeLogic',
        TemplateDefine::TYPE_SCUFFLE_CAR => 'Tool\LoadTemplate\Logic\ScrimmageCarLogic',
        TemplateDefine::TYPE_SCUFFLE_TITLE => 'Tool\LoadTemplate\Logic\ScrimmageTitleLogic',
        TemplateDefine::TYPE_SHOP_SEASON => 'Tool\LoadTemplate\Logic\SeasonStoreLogic',
        TemplateDefine::TYPE_ACTIVITY_WELFARE => 'Tool\LoadTemplate\Logic\ActivityWelfareLogic',
        TemplateDefine::TYPE_SHIELD_WORDS => 'Tool\LoadTemplate\Logic\ShieldWordsLogic',
        TemplateDefine::TYPE_SCUFFLE_SCORE => 'Tool\LoadTemplate\Logic\ScuffleScoreLogic',
        TemplateDefine::TYPE_SHOP_ZL => 'Tool\LoadTemplate\Logic\ZLStoreLogic',
        TemplateDefine::TYPE_INTIMACY => 'Tool\LoadTemplate\Logic\IntimacyLogic',
        TemplateDefine::TYPE_INTIMACY_REWARD => 'Tool\LoadTemplate\Logic\IntimacyRewardLogic',
        TemplateDefine::TYPE_PLAYER_LEVEL => 'Tool\LoadTemplate\Logic\PlayerLevelLogic',
        TemplateDefine::TYPE_PLAYER_HEAD_MODEL => 'Tool\LoadTemplate\Logic\PlayerHeadModelLogic',
        TemplateDefine::TYPE_SHOP_RECOMMEND => 'Tool\LoadTemplate\Logic\ShopRecommendLogic',
        TemplateDefine::TYPE_SHOP_BLIND_BOX => 'Tool\LoadTemplate\Logic\ShopBlindBoxLogic',
        TemplateDefine::TYPE_BLIND_BOX => 'Tool\LoadTemplate\Logic\BlindBoxLogic',
        TemplateDefine::TYPE_SHOP_EXCHANGE => 'Tool\LoadTemplate\Logic\ShopExchangeLogic',
        TemplateDefine::TYPE_TASK_EXCHANGE => 'Tool\LoadTemplate\Logic\TaskExchangeLogic',
        TemplateDefine::TYPE_TASK_LOGIN => 'Tool\LoadTemplate\Logic\TaskLoginLogic',
        TemplateDefine::TYPE_TASK_TARGET => 'Tool\LoadTemplate\Logic\TaskTargetLogic',
        TemplateDefine::TYPE_TASK_FESTIVAL => 'Tool\LoadTemplate\Logic\TaskFestivalLogic',
        TemplateDefine::TYPE_RANK_ACTIVE => 'Tool\LoadTemplate\Logic\RankActiveLogic',
        TemplateDefine::TYPE_RANK_STRAIGHT_WIN => 'Tool\LoadTemplate\Logic\RankStraightWinLogic',
        TemplateDefine::TYPE_RANK_WIN_RATIO => 'Tool\LoadTemplate\Logic\RankWinRatioLogic',
        TemplateDefine::TYPE_RANK_TEAM_POSITION => 'Tool\LoadTemplate\Logic\RankPositionLogic',
        TemplateDefine::TYPE_RANK_MATCH => 'Tool\LoadTemplate\Logic\RankMatchLogic',
        TemplateDefine::TYPE_RANKING_TEST => 'Tool\LoadTemplate\Logic\RankingTestLogic',
        TemplateDefine::TYPE_LICENSE_REWARD => 'Tool\LoadTemplate\Logic\LicenseRewardLogic',
        TemplateDefine::TYPE_SKIN_ATTRIBUTION => 'Tool\LoadTemplate\Logic\SkinAttributionLogic',
        TemplateDefine::TYPE_AI => 'Tool\LoadTemplate\Logic\AiLogic',
        TemplateDefine::TYPE_GUIDE_AI => 'Tool\LoadTemplate\Logic\GuideAILogic',
    );

    public const TIDY_DEFINE = array(
        TemplateDefine::TYPE_MAIL => 'Tool\LoadTemplate\Tidy\MailTidy',
        TemplateDefine::TYPE_RANDOM_ID => 'Tool\LoadTemplate\Tidy\RandomIdTidy',
        TemplateDefine::TYPE_DEEPMOD => 'Tool\LoadTemplate\Tidy\DeepmodTidy',
        TemplateDefine::TYPE_TASK => 'Tool\LoadTemplate\Tidy\TaskTidy',
        TemplateDefine::TYPE_TALE => 'Tool\LoadTemplate\Tidy\TaleTidy',
        TemplateDefine::TYPE_CLOTHING => 'Tool\LoadTemplate\Tidy\ClothingTidy',
        TemplateDefine::TYPE_GENERATE_AI => 'Tool\LoadTemplate\Tidy\GenerateAiTidy',
        TemplateDefine::TYPE_SHOP_CAR => 'Tool\LoadTemplate\Tidy\ShopCarTidy',
        TemplateDefine::TYPE_SHOP_SEASON => 'Tool\LoadTemplate\Tidy\SeasonStoreTidy',
        TemplateDefine::TYPE_SHOP_ZL => 'Tool\LoadTemplate\Tidy\ZLStoreTidy',
        TemplateDefine::TYPE_PLAYER_LEVEL => 'Tool\LoadTemplate\Tidy\PlayerLevelTidy',
        TemplateDefine::TYPE_PLAYER_HEAD_MODEL => 'Tool\LoadTemplate\Tidy\PlayerHeadTidy',
        TemplateDefine::TYPE_GUIDE_AI => 'Tool\LoadTemplate\Tidy\GuideAiTidy',
    );
}
