<?php

/**
 * 初始赛季信息
 */

namespace Tool\InitServer\Logic;

use Framework\Lib\Utils;
use Framework\Model\CommonSeasonStatusModel;
use Framework\MVC\ModelManager;
use Framework\Logic\CommonDataLogic;
use Framework\Logic\TemplateHelp;
use Framework\Model\CommonSeasonModel;
use Framework\Model\CommonSeasonWeekModel;
use Game\Constant\ConstTemplate\TemplateMatchTime;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Tool\InitServer\IBase;

class InitSeason extends IBase
{
    use TemplateHelp;
    use CommonDataLogic;

    protected function run(): bool
    {
        //检查当前时间所在的赛季
        $seasonConfigData = $this->getTable(TemplateDefine::TYPE_MATCH_TIME);
        if (is_null($seasonConfigData)) {
            echo "MatchTime table not found";
            echo "<br>\n";
            return false;
        }
        $now = Utils::getServerTimestamp();
        $seasonId = null;
        $expireTime = null;
        foreach ($seasonConfigData as $id => $seasonData) {
            if ($seasonData[TemplateMatchTime::StartTime] == "None" ||
                $seasonData[TemplateMatchTime::EndTime] == "None"
            ) {
                continue;
            }
            if ($now >= $seasonData[TemplateMatchTime::StartTime] && $now <= $seasonData[TemplateMatchTime::EndTime]) {
                $seasonId = $seasonData[TemplateMatchTime::Id];
                $expireTime = $seasonData[TemplateMatchTime::EndTime];
                break;
            }
        }
        if (is_null($seasonId) || is_null($expireTime)) {
            echo "Season id not found";
            echo "<br>\n";
            return false;
        }
        return $this->initSeason($seasonId, $expireTime);
    }

    //初始赛季信息
    private function initSeason(int $seasonId, int $expireTime): bool
    {
        //设置赛季Id
        /**
         * @var CommonSeasonModel $commonSeason
         */
        $commonSeason = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_SEASON);
        $bool = $commonSeason->setSeasonId($seasonId, $expireTime);
        if (false == $bool) {
            echo "Init Season addCommonData Fail";
            echo "<br>\n";
            return false;
        }
        //设置赛季状态
        /**
         * @var CommonSeasonStatusModel $commonSeasonStatus
         */
        $commonSeasonStatus = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_SEASON_STATUS);
        $bool = $commonSeasonStatus->setSeasonStatus($seasonId);
        if (false == $bool) {
            echo "Init Season Status Fail";
            echo "<br>\n";
            return false;
        }
        //设置赛季周
        /**
         * @var CommonSeasonWeekModel $commonSeasonWeek
         */
        $commonSeasonWeek = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_SEASON_WEEK);
        $week = $commonSeasonWeek->calculateSeasonWeek($seasonId);
        if ($week == 0) {
            echo "Init Season week Fail";
            echo "<br>\n";
            return false;
        }
        $commonSeasonWeek->setSeasonWeek($week);
        echo "Init Season Success! now SeasonId:{$seasonId}, Season Week:{$week}";
        echo "<br>\n";
        return true;
    }

}