<?php

/**
 * 初始活动时间
 */

namespace Tool\InitServer\Logic;

use Framework\Logic\TemplateHelp;
use Game\Constant\TemplateDefine;
use Tool\InitServer\Config;
use Tool\InitServer\IBase;

class InitActivityTime extends IBase
{
    use TemplateHelp;

    protected function run(): bool
    {
        $config = $this->getTable(TemplateDefine::TYPE_ACTIVITY_TIME);
        if (is_null($config)) {
            echo "activity time config not found";
            return false;
        }
        //处理各个活动
        foreach (Config::ACTIVITY_INIT_MODEL as $activity => $class) {
            $model = new $class();
            if (!isset($config[$activity])) {
                echo "activity config not found:{$activity}"."\n<br>";
                continue;
            }
            $model->initActivity($config[$activity]);
        }
        return true;
    }
}
