<?php

/**
 * 生成AI并保存到DB
 */

namespace Tool\InitServer\Logic;

use Framework\MVC\ModelManager;
use Framework\DB\Handler\CommonDBHandler;
use Framework\DB\Handler\PlayerDBHandler;
use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateGenerateAi;
use Game\Constant\DBTableDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\GenerateAiLogic;
use Game\Logic\Pvp\MatchAILogic;
use Game\Protobuf\AIInfo;
use Tool\InitServer\IBase;

class GenerateAIPlayer extends IBase
{
    use PlayerDBHandler;
    use CommonDBHandler;
    use TemplateHelp;

    use GenerateAiLogic;
    use MatchAILogic;


    protected function run(): bool
    {
        ModelManager::getInstance()->setPlayerId(0);
        //先删除旧AI
        $this->delAI();
        //生成初级AI
        if (!$this->generateAIPlayer(TemplateGenerateAi::AI_LEVEL_1)) {
            return false;
        }
        //生成中级AI
        if (!$this->generateAIPlayer(TemplateGenerateAi::AI_LEVEL_2)) {
            return false;
        }
        //生成高级AI
        if (!$this->generateAIPlayer(TemplateGenerateAi::AI_LEVEL_3)) {
            return false;
        }
        echo "Generate AI success";
        echo "<br>\n";
        return true;
    }

    private function generateAIPlayer(int $level): bool
    {
        $config = $this->getTitle(TemplateDefine::TYPE_GENERATE_AI, $level);
        if (is_null($config)) {
            echo "generate AI Fail,not found GenerateAi config,level:{$level}";
            echo "<br>\n";
            return false;
        }
        foreach ($config[TemplateGenerateAi::AIIds] as $aiTplId) {
            foreach ($config[TemplateGenerateAi::CAR_POSITION] as $position => $carArr) {
                $maxNum = GameConstantDefine::AI_PLAYER_MAX_ID;
                while ($maxNum > 0) {
                    $aiInfo = $this->generateAI($level, $maxNum, $aiTplId, $position);
                    if (is_null($aiInfo)) {
                        echo "generate AI Fail,AI level:".$level;
                        echo "<br>\n";
                        return false;
                    }
                    //保存
                    if (false == $this->saveAIData($level, $aiInfo)) {
                        echo "save AI Fail,AI level:".$level;
                        echo "<br>\n";
                        return false;
                    }
                    $maxNum--;
                }
            }
        }
        echo "generate AI level:{$level} success";
        echo "<br>\n";
        return true;
    }

    private function saveAIData(int $level, AIInfo $aiInfo): bool
    {
        $data = array(
            $aiInfo->getPlayerId() => $aiInfo->serializeToJsonString()
        );
        return $this->updateTitle(
            DBTableDefine::TABLE_AI_PLAYER,
            0,
            $this->getAITitle($level, $aiInfo->getAITplId()),
            $data
        );
    }

    //删除AI
    private function delAI()
    {
        $config = $this->getTable(TemplateDefine::TYPE_GENERATE_AI);
        if (is_null($config)) {
            echo "generate AI Fail,not found GenerateAi config";
            echo "<br>\n";
        }
        foreach ($config as $level => $configData) {
            foreach ($configData[TemplateGenerateAi::AIIds] as $AITplId) {
                $this->deleteCommTitle(DBTableDefine::TABLE_AI_PLAYER, $this->getAITitle($level, $AITplId));
            }
        }
    }
}
