<?php

/**
 * 初始大乱斗活动
 */

namespace Tool\InitServer\Logic\Activity;

use Framework\DB\Handler\CommonDBHandler;
use Framework\Lib\Utils;
use Framework\Logic\Activity\CommonScuffleLogic;
use Game\Constant\ActivityDefine;
use Game\Constant\ConstTemplate\TemplateActivityTime;
use Game\Constant\DBTableDefine;
use Game\Constant\GameConstantDefine;

class InitScuffle
{
    use CommonDBHandler;

    use CommonScuffleLogic;

    public function initActivity(array $config): bool
    {
        $config = $config[0];
        //获取活动
        [$weekId, $status, $startTime, $endTime] = $this->getActivityTimeByWeek(
            $config[TemplateActivityTime::TimeParameter],
            $config[TemplateActivityTime::TimeGap]
        );
        $activityId = $this->markScuffleActivityId($weekId);
        //检查当前活动状态
        [$nowActivityId, $nowActivityStatus] = $this->getScuffleActivityIdFromDB();
        if ($nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_DOING) {
            echo "now scuffle activity id is: {$nowActivityId}, activity is open";
            echo "<br>\n";
            return true;
        }
        if ($nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_UNOPENED) {
            echo "scuffle activity id is: {$nowActivityId}, wait to open";
            echo "<br>\n";
            return true;
        }

        //检查开启时间,活动现在开启还是定时开启
        if ($status == ActivityDefine::ACTIVITY_STATUS_UNOPENED) {
            //定时开启,设置开启结束时间
            $this->setScuffleOpenTime($activityId, $startTime);
            $this->setScuffleCloseTime($activityId, $endTime);
            echo "scuffle activity id is: {$activityId}, wait to open on: {$startTime}";
            echo "<br>\n";
        } else {
            //立即开启
            $this->openScuffle($activityId);
            $this->setScuffleCloseTime($activityId, $endTime);
            echo "scuffle activity id is: {$activityId}, open now!";
            echo "<br>\n";
        }
        return true;
    }

    //查询当前进行的活动id
    private function getScuffleActivityIdFromDB(): array
    {
        $result = array();
        $this->searchCommonTitle(
            DBTableDefine::TABLE_COMMON_CONST,
            0,
            $result
        );
        return [
            isset($result[GameConstantDefine::COMMON_KEY_ACTIVITY_SCUFFLE]) ?
                (int)$result[GameConstantDefine::COMMON_KEY_ACTIVITY_SCUFFLE] :
                0,
            isset($result[GameConstantDefine::COMMON_KEY_ACTIVITY_SCUFFLE_STATUS]) ?
                (int)$result[GameConstantDefine::COMMON_KEY_ACTIVITY_SCUFFLE_STATUS] :
                -1
        ];
    }

    //周内开启时间活动 获取开始 结束时间
    //返回 [周Id,状态,开始时间,结束时间]
    public function getActivityTimeByWeek(array $openWeekList, int $lastDay): array
    {
        $nowWeekDay = date("N");   //1-7 周1-周日
        if (in_array($nowWeekDay, $openWeekList)) {
            //当天有开启的活动
            $startTime = strtotime(Utils::getWeekEn($nowWeekDay), strtotime(date("Y-m-d")));
            return [
                $nowWeekDay,
                ActivityDefine::ACTIVITY_STATUS_DOING,
                $startTime,
                $startTime + $lastDay * 86400 -1
            ];
        }
        $canOpenWeek = null;
        foreach ($openWeekList as $openWeek) {
            if ($openWeek < $nowWeekDay) {
                //已过去的时间
                continue;
            }
            if ($openWeek > $nowWeekDay) {
                //还未开启
                $canOpenWeek = $openWeek;
                break;
            }
        }
        if (is_null($canOpenWeek)) {
            //当前时间错过了全部的开启时间,选第一个开启时间
            $canOpenWeek = $openWeekList[0];
        }
        $startTime = strtotime(Utils::getWeekEn($canOpenWeek), strtotime(date("Y-m-d")));
        return [
            $canOpenWeek,
            ActivityDefine::ACTIVITY_STATUS_UNOPENED,
            $startTime,
            $startTime + $lastDay * 86400 -1
        ];
    }
}
