<?php

/**
 * 初始地图挑战赛活动
 */

namespace Tool\InitServer\Logic\Activity;

use Framework\DB\Handler\CommonDBHandler;
use Framework\Lib\Utils;
use Framework\Logic\Activity\CommonMapChallengeLogic;
use Framework\Logic\TemplateHelp;
use Game\Constant\ActivityDefine;
use Game\Constant\ConstTemplate\TemplateActivityTime;
use Game\Constant\DBTableDefine;
use Game\Constant\GameConstantDefine;

class InitMapChallenge
{
    use TemplateHelp;
    use CommonDBHandler;

    use CommonMapChallengeLogic;

    //config ActivityTime
    public function initActivity(array $config): bool
    {
        //获取活动id
        $activityId = 0;
        $now = Utils::getServerTimestamp();
        $activityConfig = null;
        $status = ActivityDefine::ACTIVITY_STATUS_UNOPENED;
        foreach ($config as $id => $configData) {
            if ($now >= $configData[TemplateActivityTime::StartTime] &&
                $now <= $configData[TemplateActivityTime::EndTime])
            {
                //活动已开始
                $activityId = $id;
                $status = ActivityDefine::ACTIVITY_STATUS_DOING;
                $activityConfig = $configData;
                break;
            }
            if ($now <= $configData[TemplateActivityTime::StartTime] &&
                $now <= $configData[TemplateActivityTime::EndTime])
            {
                //未开启
                if ($activityId == 0) {
                    $activityId = $id;
                    $activityConfig = $configData;
                }
                if ($id < $activityId) {
                    $activityId = $id;
                    $activityConfig = $configData;
                }
            }
        }
        if ($activityId == 0) {
            //未找到能开启的活动id
            echo "map challenge config time error,not found can open activity";
            echo "<br>\n";
            return false;
        }

        //检查当前活动状态
        [$nowActivityId, $nowActivityStatus] = $this->getMapChallengeActivityIdFromDB();
        if ($nowActivityStatus == -1) {
            //新服,按初始化流程
            if ($now >= $activityConfig[TemplateActivityTime::StartTime]) {
                //已到开启时间,立即开启
                //立即开启
                $this->openMapChallenge($activityId);
                echo "map challenge activity id is: {$activityId}, open now!";
                echo "<br>\n";
                return true;
            }
            //定时开启,设置开启时间
            $this->setMapChallengeOpenTime($activityId, $activityConfig[TemplateActivityTime::StartTime]);
            //设置结束时间
            $this->setMapChallengeCloseTime($activityId, $activityConfig[TemplateActivityTime::EndTime]);
            echo "new server,map challenge activity id is: {$activityId}, wait to open on: {$activityConfig[TemplateActivityTime::StartTime]}";
            echo "<br>\n";
            return true;
        }

        if ($nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_DOING) {
            echo "now map challenge activity id is: {$nowActivityId}, activity is open";
            echo "<br>\n";
            return true;
        }
        if ($nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_UNOPENED) {
            echo "map challenge activity id is: {$nowActivityId}, wait to open";
            echo "<br>\n";
            return true;
        }

        //检查开启时间,活动现在开启还是定时开启
        if ($status == ActivityDefine::ACTIVITY_STATUS_UNOPENED) {
            //定时开启,设置开启时间
            $this->setMapChallengeOpenTime($activityId, $activityConfig[TemplateActivityTime::StartTime]);
            //设置结束时间
            $this->setMapChallengeCloseTime($activityId, $activityConfig[TemplateActivityTime::EndTime]);
            echo "map challenge activity id is: {$activityId}, wait to open on: {$activityConfig[TemplateActivityTime::StartTime]}";
            echo "<br>\n";
        } else {
            //立即开启
            $this->openMapChallenge($activityId);
            echo "map challenge activity id is: {$activityId}, open now!";
            echo "<br>\n";
        }

        return true;
    }

    //查询当前进行的地图挑战活动id
    private function getMapChallengeActivityIdFromDB(): array
    {
        $result = array();
        $this->searchCommonTitle(
            DBTableDefine::TABLE_COMMON_CONST,
            0,
            $result
        );
        return [
            isset($result[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE]) ?
                (int)$result[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE] :
                0,
            isset($result[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE_STATUS]) ?
                (int)$result[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE_STATUS] :
                -1
        ];
    }
}
