<?php

/**
 * Load.php
 */

namespace Tool\InitServer;

use Throwable;

class Load
{
    public function __construct()
    {
        $this->registerHandler();
    }

    public function deal(): bool
    {
        foreach (Config::INIT_MODEL as $model) {
            $mod = new $model;
            if (false == $mod->execute()) {
                echo sprintf("%s model init Fail", $model)."<br>";
                return false;
            }
        }
        return true;
    }

    private function registerHandler()
    {
        set_exception_handler(function (Throwable $exception) {
            echo "Uncaught exception: " , $exception->getMessage(), "\n";
        });

        set_error_handler(function (int $number, string $message, string $error_file, int $error_line) {
            echo "Handler captured error $number: '$message' file:'$error_file' row:'$error_line'" . PHP_EOL  ;
        });

        register_shutdown_function(function () {
            // todo 程序结束后，检查是否有报错情况
        });
    }
}
