<?php

namespace Tool\InitServer;

use Framework\Common\ConfigManager;
use Game\Constant\DBTableDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\PacketDefineI;

abstract class IBase
{
    public function execute(): bool
    {
        $this->loadConfig();
        return $this->run();
    }

    protected function loadConfig()
    {
        ConfigManager::getInstance()->setPacketDefine(new PacketDefineI());
        ConfigManager::getInstance()->setModelDefine(new ModelTypeDefine());
        ConfigManager::getInstance()->setRedisConfig(new DBTableDefine());
        ConfigManager::getInstance()->loadConfig();
    }

    abstract protected function run(): bool;
}
