<?php

namespace Tool\InitServer;

use Game\Constant\ActivityDefine;
use Tool\InitServer\Logic\Activity\InitMapChallenge;
use Tool\InitServer\Logic\Activity\InitScuffle;
use Tool\InitServer\Logic\GenerateAIPlayer;
use Tool\InitServer\Logic\InitActivityTime;
use Tool\InitServer\Logic\InitPaiWeiGoldTime;
use Tool\InitServer\Logic\InitRoleIds;
use Tool\InitServer\Logic\InitSeason;
use Tool\InitServer\Logic\InitServerState;

class Config
{
    public const ROLE_ID_NUM = 1000;    //生成roleId数量

    public const SERVER_MODULE_KEY = "ModuleState";
    public const SERVER_STATE_KEY = "ServerState";
    public const SERVER_TYPE_READY_OPEN = 0;      // 准备中
    public const SERVER_TYPE_OPENING    = 1;      // 开服中
    public const SERVER_TYPE_CLOSED     = 2;      // 关服中
    public const SERVER_TYPE_SERVICE    = 3;      // 维护中

    public const INIT_MODEL = array(
        InitSeason::class,      //初始赛季信息
        InitRoleIds::class,     //初始RoleId
        GenerateAIPlayer::class,    //生成AI
        InitActivityTime::class,    //初始各个活动
        InitServerState::class,     //初始服务器状态
        InitPaiWeiGoldTime::class,  //初始排位赛金牌车手检查时间
    );

    //活动初始
    public const ACTIVITY_INIT_MODEL = array(
        ActivityDefine::ACTIVITY_NAME_MAP_CHALLENGE => InitMapChallenge::class,
        ActivityDefine::ACTIVITY_NAME_SCUFFLE => InitScuffle::class,
    );
}
