<?php

/**
 * 活动时间检查,修复
 */

namespace Tool\FixHelper\Tool;

use Framework\Logic\Activity\CommonMapChallengeLogic;
use Framework\Logic\Activity\CommonScuffleLogic;
use Framework\Logic\CommonTimerLogic;
use Framework\Logic\TemplateHelp;
use Game\Constant\ActivityDefine;
use Game\Constant\ConstTemplate\TemplateActivityTime;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\CommonConstLogic;
use Tool\FixHelper\IBase;
use Tool\InitServer\Logic\Activity\InitScuffle;

class ActivityTimeFixHelper extends IBase
{
    use TemplateHelp;
    use CommonConstLogic;
    use CommonTimerLogic;
    use CommonMapChallengeLogic;
    use CommonScuffleLogic;

    private array $commonConstData = array();
    private array $commonTimerData = array();

    protected function run(): bool
    {
        $config = $this->getTable(TemplateDefine::TYPE_ACTIVITY_TIME);
        if (is_null($config)) {
            echo "activity time config not found";
            return false;
        }
        //获取当前活动时间等配置
        $this->commonConstData = $this->getCommonConstData();
        $this->commonTimerData = $this->getAllCommonTimer();
        //根据活动 依次检查时间
        $this->checkMapChallengeTime($config[ActivityDefine::ACTIVITY_NAME_MAP_CHALLENGE]);
        $this->checkScuffleTime($config[ActivityDefine::ACTIVITY_NAME_SCUFFLE]);
        return true;
    }

    //检查地图挑战赛时间
    private function checkMapChallengeTime(array $mapChallengeConfig)
    {
        echo "[MapChallenge] start check mapChallenge Time";
        echo "\n";
        //当前进行的活动
        $nowActivityId = $this->commonConstData[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE];
        $nowActivityStatus = $this->commonConstData[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE_STATUS];
        //检查结束时间是否一致
        if(!isset($mapChallengeConfig[$nowActivityId])) {
            echo "[MapChallenge] not found now activity config";
            echo "\n";
            return;
        }
        switch ($nowActivityStatus)
        {
            case ActivityDefine::ACTIVITY_STATUS_UNOPENED:
                $config = $mapChallengeConfig[$nowActivityId];
                //当前活动未开启
                echo "[MapChallenge] now not open, activityId:{$nowActivityId}";
                echo "\n";
                //检查下次开启时间
                $titleId = ActivityDefine::makeActivityTitleKey(
                    ActivityDefine::ACTIVITY_NAME_MAP_CHALLENGE,
                    ActivityDefine::ACTIVITY_STATUS_UNOPENED,
                    $nowActivityId
                );
                $key = ModelTypeDefine::COMMON_ACTIVITY . "-" . $titleId;
                $nowStartTime = $this->commonTimerData[$key] ?? 0;
                $configStartTime = $config[TemplateActivityTime::StartTime];
                if ($nowStartTime != $configStartTime) {
                    echo "[MapChallenge] now activity start time not equal,
                    nowStartTime:{$nowStartTime} \n
                    configStartTime:{$configStartTime}";
                    echo "\n";
                    //修复活动时间
                    //移除错误的时间
                    $this->delCommonTimer(ModelTypeDefine::COMMON_ACTIVITY, $titleId);
                    //设置新的开始时间
                    $this->setMapChallengeOpenTime($nowActivityId, $configStartTime);
                    echo "[MapChallenge] fix start time,startTime:{$configStartTime}";
                    echo "\n";
                    return;
                }
                echo "[MapChallenge] now activity start time equal,
                    nowStartTime:{$nowStartTime} \n
                    configStartTime:{$configStartTime}";
                echo "\n";
                break;
            case ActivityDefine::ACTIVITY_STATUS_DOING:
                $config = $mapChallengeConfig[$nowActivityId];
                //当前活动正在进行
                echo "[MapChallenge] now open, activityId:{$nowActivityId}";
                echo "\n";
                $nowEndTime = strtotime($this->commonConstData[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE_END_TIME]);
                $configEndTime = $config[TemplateActivityTime::EndTime];
                if ($nowEndTime != $configEndTime) {
                    echo "[MapChallenge] now activity end time not equal,
                    nowEndTime:{$nowEndTime} \n
                    configEndTime:{$configEndTime}";
                    echo "\n";
                    //修复活动时间
                    //移除错误的时间
                    $titleId = ActivityDefine::makeActivityTitleKey(
                        ActivityDefine::ACTIVITY_NAME_MAP_CHALLENGE,
                        ActivityDefine::ACTIVITY_STATUS_CLOSE,
                        $nowActivityId
                    );
                    $this->delCommonTimer(ModelTypeDefine::COMMON_ACTIVITY, $titleId);
                    //设置新的结束时间
                    $this->setMapChallengeCloseTime($nowActivityId, $configEndTime);
                    echo "[MapChallenge] fix end time,endTime:{$configEndTime}";
                    echo "\n";
                    return;
                }
                echo "[MapChallenge] now activity end time equal,
                    nowEndTime:{$nowEndTime} \n
                    configEndTime:{$configEndTime}";
                echo "\n";
                break;
            case ActivityDefine::ACTIVITY_STATUS_CLOSE:
                //活动已关闭
                echo "[MapChallenge] now close, activityId:{$nowActivityId}";
                echo "\n";
                if(!isset($mapChallengeConfig[$nowActivityId + 1])) {
                    echo "[MapChallenge] not found next activity config,last activityId:{$nowActivityId}";
                    echo "\n";
                    return;
                }
                //设置下次开启
                $config = $mapChallengeConfig[$nowActivityId + 1];
                $configStartTime = $config[TemplateActivityTime::StartTime];
                $configEndTime = $config[TemplateActivityTime::EndTime];
                $this->setMapChallengeOpenTime($nowActivityId + 1, $configStartTime);
                $this->setMapChallengeCloseTime($nowActivityId + 1, $configEndTime);
                echo "[MapChallenge] set next activity wait open,nexStartTime:{$configStartTime}";
                echo "\n";
                break;
        }
    }

    //检查大乱斗活动时间
    private function checkScuffleTime(array $scuffleConfig)
    {
        $config = $scuffleConfig[0];
        $scuffleTool = new InitScuffle();
        [$weekId, $status, $startTime, $endTime] = $scuffleTool->getActivityTimeByWeek(
            $config[TemplateActivityTime::TimeParameter],
            $config[TemplateActivityTime::TimeGap]
        );
        $activityId = $this->markScuffleActivityId($weekId);
        echo "[Scuffle] start check scuffle Time";
        echo "\n";
        //当前进行的活动状态
        $nowActivityId = $this->commonConstData[GameConstantDefine::COMMON_KEY_ACTIVITY_SCUFFLE];
        $nowActivityStatus = $this->commonConstData[GameConstantDefine::COMMON_KEY_ACTIVITY_SCUFFLE_STATUS];
        if ($status == ActivityDefine::ACTIVITY_STATUS_UNOPENED) {
            //当天没有正在进行的活动
            if ($nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_UNOPENED ||
                $nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_CLOSE
            ) {
                //当天未开启,检查下次开启时间是否一致
                //检查下次开启时间
                $titleId = ActivityDefine::makeActivityTitleKey(
                    ActivityDefine::ACTIVITY_NAME_SCUFFLE,
                    ActivityDefine::ACTIVITY_STATUS_UNOPENED,
                    $nowActivityId
                );
                $key = ModelTypeDefine::COMMON_ACTIVITY . "-" . $titleId;
                $nextStartTime = $this->commonTimerData[$key] ?? 0;
                if ($nextStartTime != $startTime) {
                    //下次开启时间不一致
                    echo "[Scuffle] now activity wait open,next start time not equal,
                    nextStartTime:{$nextStartTime} \n
                    configNextStartTime:{$startTime}";
                    //修复活动时间
                    $this->delCommonTimer(ModelTypeDefine::COMMON_ACTIVITY, $titleId);
                    //设置新的开始时间
                    $this->setScuffleOpenTime($activityId, $startTime);
                    $this->setScuffleCloseTime($activityId, $endTime);
                    echo "[Scuffle] fix next start time,startTime:{$startTime}";
                    echo "\n";
                    return;
                }
                echo "[Scuffle] wait open,next start time equal,
                    nextStartTime:{$nextStartTime} \n
                    configNextStartTime:{$startTime}";
                echo "\n";
                return;
            }
            if ($nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_DOING) {
                //当天不应该开启活动
                echo "[Scuffle] now activity should be close,but is open,close activity";
                echo "\n";
                //修复活动时间
                $titleId = ActivityDefine::makeActivityTitleKey(
                    ActivityDefine::ACTIVITY_NAME_SCUFFLE,
                    ActivityDefine::ACTIVITY_STATUS_CLOSE,
                    $nowActivityId
                );
                $this->delCommonTimer(ModelTypeDefine::COMMON_ACTIVITY, $titleId);
                $this->closeScuffle($nowActivityId);
                return;
            }
        } elseif ($status == ActivityDefine::ACTIVITY_STATUS_DOING) {
            //当天正在进行活动
            if ($nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_DOING) {
                //当天正在进行活动,检查结束时间
                echo "[Scuffle] now open, activityId:{$nowActivityId}";
                echo "\n";
                $titleId = ActivityDefine::makeActivityTitleKey(
                    ActivityDefine::ACTIVITY_NAME_SCUFFLE,
                    ActivityDefine::ACTIVITY_STATUS_CLOSE,
                    $nowActivityId
                );
                $key = ModelTypeDefine::COMMON_ACTIVITY . "-" . $titleId;
                $nowCloseTime = $this->commonTimerData[$key] ?? 0;
                if ($nowCloseTime != $endTime) {
                    //结束时间不一致
                    echo "[Scuffle] now activity open,close time not equal,
                    nowCloseTime:{$nowCloseTime} \n
                    configCloseTime:{$endTime}";
                    //修复活动时间
                    $this->delCommonTimer(ModelTypeDefine::COMMON_ACTIVITY, $titleId);
                    $this->setScuffleCloseTime($nowActivityId, $endTime);
                    echo "[Scuffle] fix close time,close time:{$endTime}";
                    echo "\n";
                    return;
                }
                echo "[Scuffle] now activity open,close time equal,
                    nowCloseTime:{$nowCloseTime} \n
                    configCloseTime:{$endTime}";
                echo "\n";
                return;
            }
            if ($nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_UNOPENED ||
                $nowActivityStatus == ActivityDefine::ACTIVITY_STATUS_CLOSE
            ) {
                //当前应该开启活动,但未开启
                echo "[Scuffle] now activity should be open,but is close,open activity:{$activityId}";
                echo "\n";
                //修复活动时间
                $titleId = ActivityDefine::makeActivityTitleKey(
                    ActivityDefine::ACTIVITY_NAME_SCUFFLE,
                    ActivityDefine::ACTIVITY_STATUS_UNOPENED,
                    $nowActivityId
                );
                $this->delCommonTimer(ModelTypeDefine::COMMON_ACTIVITY, $titleId);
                $this->openScuffle($activityId);
                $this->setScuffleCloseTime($activityId, $endTime);
                return;
            }
        }
    }
}
