<?php

namespace Test;

require_once __DIR__ . '/../Framework/AutoLoad.php';

use Redis;
use RedisCluster;
use RedisClusterException;

$node = array(
    '127.0.0.1:1001',
    '127.0.0.1:1002',
    '127.0.0.1:1003',
);

$redis = new Redis();
$redis->pconnect("127.0.0.1", 1000);
$redisCluster = new RedisCluster(null, $node);


function makeObjectID($serverId, $modelType, $index): int
{
    // type 7 , serverId 10 , index 15 , time 32
    $time = time();
    $ret = (($modelType & 0x0000007F) << 25) | (($serverId & 0x000003FF) << 15) | ($index & 0x00007FFF);
    $ret = dechex($ret) . dechex($time);
    $a = gmp_init($ret, 16);
    return gmp_strval($a);
}

$index = $index = rand(1, 32768);
$uid = makeObjectID(1, 13, $index);

$playerId = "288422203925973680";

$key1 = "{1-1-$playerId}-Mail";
$key2 = "{1-1-$playerId}-Mail-{$uid}";
$key3 = "{1-1-$playerId}-Timer";
$arr = array(
    "MailTplId" => 4,
    "Uid" => $uid,
    "ReceiveTime" => 1649839081,
    "Status" => 0,
    "ExpireTime" => "1652431081",
    "Enclosure" => '{"101100001": 9,"103300003": 5}'
);

$redisCluster->zAdd($key1, 1652431081, $uid);
$redisCluster->hMSet($key2, $arr);
$redisCluster->zAdd($key3, 1652431081, "13-{$uid}");

$redis->close();
$redisCluster->close();

