<?php

/**
 * 模拟客户端测试给服务器发送消息
 * Created On 2021/11/1
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Test;

require_once __DIR__ . '/../Library/AutoLoad.php';

use Framework\Protobuf\WebRequestMessage;
use Framework\Protobuf\SinglePacket;
use Game\Protobuf\TestSend;

const URL = "http://192.168.0.30:2333/GameIndex.php";
$message = new WebRequestMessage();
$message->setIndex(1);
$message->setServerId(1);
$message->setSession('12s123sdf');

$packet = new TestSend();
$packet->setA(123);
$packet->setB(18.36);
$packet->setC(1823456861364);
$packet->setD(true);
$packet->setE('kiss me');
$packetStr = base64_encode($packet->serializeToString());

$single_packet = new SinglePacket();
$single_packet->setId(1);
$single_packet->setData($packetStr);

$message->setPacketList([$single_packet]);
$packet_str = $message->serializeToString();

$curl = curl_init(URL);
$options = array(
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $packet_str,
    CURLOPT_HEADER => false,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 10
);
curl_setopt_array($curl, $options);
$response = curl_exec($curl);
echo $response;
