<?php

/**
 * 测试道具模块
 * Created On 2022/1/19
 * @author lfx
 */

namespace Test;

require_once __DIR__ . '/../Library/AutoLoad.php';

use Framework\MVC\ModelManager;
use Framework\Network\ReceiveMessage;
use Framework\Protobuf\WebRequestMessage;
use Framework\Protobuf\SinglePacket;
use Game\Model\ItemModel;
use Game\Protobuf\AddItemSingle;
use Game\Protobuf\GainItemSend;
use Game\Protobuf\ItemSingle;
use Game\Protobuf\TestSend;
use Game\Logic\ItemLogic;
use Game\Controller\UseItem;

use Game\Constant\DBTableDefine;
use Game\Constant\PacketDefineI;
use Game\Constant\ModelTypeDefine;
use Framework\Common\ConfigManager;

$playerID = 288482535324937599;
ConfigManager::getInstance()->setPacketDefine(new PacketDefineI());
ConfigManager::getInstance()->setModelDefine(new ModelTypeDefine());
ConfigManager::getInstance()->setRedisConfig(new DBTableDefine());
ModelManager::getInstance()->setPlayerId($playerID);
ConfigManager::getInstance()->loadConfig();


// 获得道具
class TestItem {
    use ItemLogic;
}


//$obj = new TestItem();
//$obj->gainItemSingle(1, 10);

//// 过期删除道具
///**
// * @var ItemModel $item
// */
//$item = ModelManager::getInstance()->getModel(3);
//
//$item->timerExpire(['432494008530524418'=>'1643272460']);

//// 使用道具
//class TestItem {
//    use ItemLogic;
//}
//$obj = new TestItem();
////$obj->useItemByUID(432571519805231547, 1);
//$obj->useItemByUID(1, 1);
exit;

const URL = "http://192.168.0.30:2333/GameIndex";
$message = new WebRequestMessage();
$message->setIndex(1);
$message->setServerId(1);
$message->setPlayerId(123564856);
$message->setSession('12s123sdf');

$packet1 = new AddItemSingle();
$packet1->setTplId(1);
$packet1->setNum(6);

$packet2 = new AddItemSingle();
$packet2->setTplId(2);
$packet2->setNum(3);

$packetArr = new GainItemSend();

$packetArr->setItem([$packet1, $packet2]);

$packetStr = base64_encode($packetArr->serializeToString());

$single_packet = new SinglePacket();
$single_packet->setId(7);
$single_packet->setData($packetStr);

$message->setPacketList([$single_packet]);
$packet_str = $message->serializeToString();

var_dump($packet_str);

$curl = curl_init(URL);
$options = array(
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $packet_str,
    CURLOPT_HEADER => false,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 10
);
curl_setopt_array($curl, $options);
$response = curl_exec($curl);
echo $response;
