<?php

/**
 * TestConfig.php
 * 文件描述
 * Created On 2022/1/26
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Test;

class TestConfig
{
    public const TEST_MONEY = 1;
    public const TEST_TIMER = 2;
    public const TEST_PAIWEI_LEVEL_CHANG_SCORE = 3;
    public const TEST_CHECK_SIGN_DATA = 4;
    public const TEST_ACCOUNT = 5;
    public const TEST_ACCOUNT_CREATE = 7;
    public const TEST_PACKET_CACHE = 8;
    public const TEST_ITEM = 9;
    public const TEST_PVP_JOIN_MATCHING = 10;
    public const TEST_PLAYER_DB = 12;
    public const TEST_MAIL = 13;
    public const TEST_COMMON_DB = 14;
    public const TEST_COMMON_MAIL = 15;
    public const TEST_COMMON_TIMER = 16;
    public const TEST_COMMON_DATA = 17;
    public const TEST_CAR = 18;
    public const TEST_SEASON_STATISTICS = 19;   //赛季信息统计
    public const TEST_FRIEND = 21;
    public const TEST_ROOM = 22;
    public const TEST_TASK = 23;
    public const TEST_DAILY_TASK = 24;
    public const TEST_MAIN_TASK = 25;
    public const TEST_BRANCH_TASK = 26;
    public const TEST_SEASON_TASK = 27;
    public const TEST_MODE = 28;
    public const TEST_DRIVING_LICENSE = 29;
    public const TEST_PVE = 30;
    public const TEST_GAME_LEVEL = 31;
    public const TEST_CLUB = 32;
    public const TEST_REDIS = 33;
    public const TEST_DRIVING_PERMIT = 34;
    public const TEST_RANK = 35;
    public const TEST_AI = 36;
    public const TEST_SHOP_ITEM = 37;   //道具商城
    public const TEST_PROFICIENCY = 38; //活跃度
    public const TEST_SHOP_CAR = 39;    //赛车商城
    public const TEST_RECORD = 40;      //统计信息
    public const TEST_MAP_CHALLENGE = 41;   //地图挑战赛
    public const TEST_SEASON_REWARD = 42;   // 赛季奖励
    public const TEST_SCUFFLE = 43;     //大乱斗
    public const TEST_SHOP_SEASON = 44; //赛季商城
    public const TEST_TASK_WEEK = 45; //赛季商城
    public const TEST_DAILY_CHALLENGE_TASK = 46;    //日常挑战任务
    public const TEST_WAR_TOKEN = 47;    // 战令相关
    public const TEST_PLAYER_ADD_EXP = 48;  //玩家加经验
    public const TEST_TEACHING_SKILL = 49;  //技巧教学
    public const TEST_SHOP_BLIND_BOX = 50;  //10连抽
    public const TEST_PIPE = 100;  //测试pipe管道
    public const TEST_SEARCH_TABLE = 101;  //测试查询整张表
    public const TEST_MODEL_MAP = array(
        self::TEST_MONEY => "Test\Money\TestMoney",
        self::TEST_TIMER => "Test\Timer\TestTimer",
        self::TEST_PAIWEI_LEVEL_CHANG_SCORE => 'Test\PaiweiLevel\TestPaiweiLevel',
        self::TEST_ACCOUNT => 'Test\Account\TestAccount',
        self::TEST_CHECK_SIGN_DATA => 'Test\CheckSignData\TestCheckSignData',
        self::TEST_ACCOUNT_CREATE => 'Test\Account\TestCreatePlayer',
        self::TEST_PACKET_CACHE => 'Test\Assist\TestPacketCache',
        self::TEST_ITEM => 'Test\Item\TestItem',
        self::TEST_PVP_JOIN_MATCHING => 'Test\Pvp\TestJoinMatching',
        self::TEST_PLAYER_DB => 'Test\DB\TestPlayerHandler',
        self::TEST_MAIL => 'Test\Mail\TestMail',
        self::TEST_COMMON_DB => 'Test\DB\TestCommonHandler',
        self::TEST_COMMON_MAIL => 'Test\Mail\TestCommonMail',
        self::TEST_COMMON_TIMER => 'Test\Common\TestTimer',
        self::TEST_COMMON_DATA => 'Test\Common\TestData',
        self::TEST_CAR => 'Test\Car\TestCar',
        self::TEST_SEASON_STATISTICS => 'Test\SeasonStatistics\TestStatistics',
        self::TEST_FRIEND => 'Test\Friend\TestFriend',
        self::TEST_ROOM => 'Test\Room\TestRoom',
        self::TEST_TASK =>'Test\Task\TestTask',
        self::TEST_DAILY_TASK =>'Test\Task\TestDailyTask',
        self::TEST_MAIN_TASK =>'Test\Task\TestMainTask',
        self::TEST_BRANCH_TASK =>'Test\Task\TestBranchTask',
        self::TEST_SEASON_TASK =>'Test\Task\TestSeasonTask',
        self::TEST_MODE =>'Test\Mode\TestMode',
        self::TEST_DRIVING_LICENSE => 'Test\DrivingLicense\TestDrivingLicense',
        self::TEST_PVE => 'Test\PVE\TestPve',
        self::TEST_GAME_LEVEL => 'Test\GameLevel\TestGameLevel',
        self::TEST_CLUB => 'Test\Club\TestClub',
        self::TEST_REDIS => 'Test\Redis\TestRedis',
        self::TEST_DRIVING_PERMIT => 'Test\DrivingPermit\TestDrivingPermit',
        self::TEST_AI => 'Test\AI\TestAI',
        self::TEST_SHOP_ITEM => 'Test\Shop\TestShopItem',
        self::TEST_RANK => 'Test\Rank\TestRank',
        self::TEST_PROFICIENCY => 'Test\Proficiency\TestProficiency',
        self::TEST_SHOP_CAR => 'Test\Shop\TestShopCar',
        self::TEST_RECORD => 'Test\Record\TestRecord',
        self::TEST_MAP_CHALLENGE => 'Test\Activity\TestMapChallenge',
        self::TEST_SCUFFLE => 'Test\Activity\TestScuffle',
        self::TEST_SHOP_SEASON => 'Test\Shop\TestShopSeason',
        self::TEST_SEASON_REWARD => 'Test\SeasonStatistics\TestSeason',
        self::TEST_TASK_WEEK => 'Test\Task\TestWeekTask',
        self::TEST_DAILY_CHALLENGE_TASK => 'Test\Task\TestDailyChallengeTask',
        self::TEST_WAR_TOKEN => 'Test\WarToken\TestWarToken',
        self::TEST_PLAYER_ADD_EXP => 'Test\Account\TestAddPlayerExp',
        self::TEST_TEACHING_SKILL => 'Test\TeachingSkill\TestTeachingSkill',
        self::TEST_SHOP_BLIND_BOX => 'Test\Shop\TestShopBlindBox',
        self::TEST_PIPE => 'Test\DB\TestPipe',
        self::TEST_SEARCH_TABLE => 'Test\DB\TestSearchTable',
    );

    public static function createTest($testType)
    {
        if (!array_key_exists($testType, self::TEST_MODEL_MAP)) {
            return null;
        }
        $testName = self::TEST_MODEL_MAP[$testType];
        return new $testName();
    }
}