<?php

/**
 * TestBase.php
 * 文件描述
 * Created On 2022/1/26
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Test;

use Framework\Common\ConfigManager;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Game\Config\GameConfig;
use Game\Constant\DBTableDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\PacketDefineI;
use Game\GameLive;
use Throwable;

abstract class TestBase
{
    private int $playerId;

    public function index($zone)
    {
        $this->playerId = $this->getPlayerId();
        $this->loadConfig($zone);
        $this->registerHandler();
        $this->initPlayerId();
        $this->startTest();
    }

    abstract public function getPlayerId(): int;

    abstract public function startTest();

    protected function loadConfig($zone)
    {
        GameLive::getInstance()->InitZone($zone);
        GameLive::getInstance()->InitLog(GameConfig::getInstance()->LOG_PATH());
        GameLive::getInstance()->InitException();
        GameLive::getInstance()->InitDefineConfig();
        GameLive::getInstance()->InitProtagonistPlayerId($this->playerId);
    }

    /**
     * 注册各类错误异常处理
     */
    private function registerHandler()
    {
        set_exception_handler(function (Throwable $exception) {
            echo "Uncaught exception: " , $exception->getMessage(), "\n";
        });

        set_error_handler(function (int $number, string $message, string $error_file, int $error_line) {
            echo "Handler captured error $number: '$message' file:'$error_file' row:'$error_line'" . PHP_EOL  ;
        });

        register_shutdown_function(function () {
            // todo 程序结束后，检查是否有报错情况
        });
    }

    private function initPlayerId()
    {
        ModelManager::getInstance()->setPlayerId($this->playerId);
        LogMark::getInstance()->setPlayerId($this->playerId);
    }
}
