<?php

namespace Test\Task;

use Framework\MVC\ModelManager;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Data\TaskData;
use Game\Logic\EventLogic;
use Game\Model\Task\Manager\TaskMangerModelBase;
use Test\TestBase;

class TestTask extends TestBase
{
    use EventLogic;

    public function getPlayerId(): int
    {
        return 2222;
    }

    public function startTest()
    {
        $taskId = 10001;
        /**
         * @var TaskMangerModelBase $taskModel
         */
        $taskModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_BASE);
        $taskModel->createTask($taskId);

        /**
         * @var TaskData $taskData
         */
        $taskData = $taskModel->getTask($taskId);
        var_dump($taskData);

        $taskData->schedule = 2;
        $taskData->status = 3;

        $taskModel->updateTask($taskData);

//        $taskModel->delTask($taskId);

        $taskModel->createTask($taskId);
        $taskModel->createTask($taskId + 1);
        $taskModel->createTask($taskId + 2);

        $taskList = $taskModel->getAllTaskByType(1);
        var_dump($taskList);

        $this->triggerEvent(2,
                            array(
                                GameConstantDefine::EVENT_KEY_NUM => 10,
                                GameConstantDefine::EVENT_KEY_CAR_ID => 1003
                            )
        );

        $taskList = $taskModel->getAllTaskByType(1);
        var_dump($taskList);

        //支线任务
        $taskId = 20111;
        $taskModel->createTask($taskId, array("CarId" => 1001));

        $taskData = $taskModel->getTask($taskId);
        var_dump($taskData);

        $taskModel->delTask($taskId);



    }
}