<?php

namespace Test\Task;

use Game\Constant\GameConstantDefine;
use Game\Logic\Task\DailyTaskLogic;
use Game\Logic\Task\TaskLogic;
use Test\TestBase;

class TestDailyTask extends TestBase
{
    use DailyTaskLogic;
    use TaskLogic;

    public function getPlayerId(): int
    {
        return 2222;
    }

    public function startTest()
    {
        //获取日常信息
        $dailyInfo = $this->getDailyActiveInfo();
        var_dump($dailyInfo);

        //获取日常任务
        $taskList = $this->getDailyTask();
        var_dump($taskList);

        //查询完成未领取任务
        $taskList = $this->getDoneDailyTask();
        var_dump($taskList);

        //触发任务
        $this->triggerEvent(2,
                            array(
                GameConstantDefine::EVENT_KEY_NUM => 10,
                GameConstantDefine::EVENT_KEY_CAR_ID => 1003
                             )
        );
        $taskList = $this->getDoneDailyTask();
        var_dump($taskList);

        //一键提交任务
        $this->submitDailyTask($taskList);

        //一键领取活跃度奖励
        list($nowLv, $canLv, $maxLv) = $this->getActiveLvData();
        $this->getActiveLvReward($nowLv, $canLv);
    }
}