<?php

namespace Test\Task;

use Game\Constant\GameConstantDefine;
use Game\Logic\Task\TaskLogic;
use Test\TestBase;

class TestBranchTask extends TestBase
{
    use TaskLogic;

    public function getPlayerId(): int
    {
        return 2222;
    }

    public function startTest()
    {
        $carId = 1003;
        //查询支线任务
        $taskList = $this->getBranchTask($carId);
        var_dump($taskList);

        //触发子任务
        $this->triggerEvent(2,
                            array(
                                GameConstantDefine::EVENT_KEY_NUM => 10,
                                GameConstantDefine::EVENT_KEY_CAR_ID => 1003
                            )
        );

        //查询支线任务
        $taskList = $this->getBranchTask($carId);
        var_dump($taskList);

        $branchMainTaskData = $taskList[0][0];
        $taskData1 = $taskList[0][1];
        $taskData2 = $taskList[0][2];
        //完成子任务
        $this->submitTask($taskData1);

        //查询支线任务--主任务进度应该更新
        $taskList = $this->getBranchTask($carId);
        var_dump($taskList);

        //完成全部子任务
        $this->submitTask($taskData2);

        //查询支线任务--主任务进度应该更新
        $taskList = $this->getBranchTask($carId);
        var_dump($taskList);

        //完成主任务
        $this->submitTask($branchMainTaskData);

        //查询支线任务--应该更新到下一级任务
        $$taskList = $this->getBranchTask($carId);
        var_dump($taskList);
    }
}
