<?php

/**
 * 测试赛季商城
 */

namespace Test\Shop;

use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Model\Shop\ShopSeasonModel;
use Test\TestBase;

class TestShopSeason extends TestBase
{
    public function getPlayerId(): int
    {
        return 288802733759869296;
    }

    public function startTest()
    {
        //获取商城道具
        /**
         * @var ShopSeasonModel $shopSeasonModel
         */
        $shopSeasonModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_SEASON);
        $shopItem = $shopSeasonModel->getShopItem();
        var_dump($shopItem);

        //赛季重置
        $shopSeasonModel->resetShopSeasonData(14);

        $shopItem = $shopSeasonModel->getShopItem();
        var_dump($shopItem);
    }
}
