<?php

/**
 * 道具商城测试
 */

namespace Test\Shop;


use Framework\MVC\ModelManager;
use Game\Constant\ClientErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Logic\MoneyLogic;
use Game\Logic\Shop\ShopItemLogic;
use Game\Model\MoneyModel;
use Game\Model\Shop\ShopItemModel;
use Test\TestBase;

class TestShopItem extends TestBase
{
    use ShopItemLogic;
    use MoneyLogic;

    public function getPlayerId(): int
    {
        return 288898923838282025;
    }

    public function startTest()
    {
        //获取商城道具
        /**
         * @var ShopItemModel $shopItemModel
         */
        $shopItemModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_ITEM);
        $shopItem = $shopItemModel->getShopItem();
        var_dump($shopItem);

        //测试购买道具
        //道具不存在
        $itemId = 1;
        $num = 1;
        var_dump(ClientErrorCode::SHOP_ITEM_NOT_FOUND == $this->buyShopItem($itemId, $num));

        //非当前批次
        $itemId = 40010;
        var_dump(ClientErrorCode::SHOP_ITEM_NOT_FOUND == $this->buyShopItem($itemId, $num));

        //货币不足
        $itemId = 40005;
        var_dump(ClientErrorCode::MONEY_TICKETS_NOT_ENOUGH == $this->buyShopItem($itemId, $num));

        //加点券
        $this->addMoney(MoneyModel::TYPE_TICKETS, 9999);

        //购买超上限
        $num = 99;
        var_dump(ClientErrorCode::SHOP_BUY_NUM_OVER_LIMIT == $this->buyShopItem($itemId, $num));

        //正常购买
        $num = 1;
        var_dump(ClientErrorCode::CLIENT_SUCCESS == $this->buyShopItem($itemId, $num));

        //查看购买数量
        $shopItem = $shopItemModel->getShopItem();
        var_dump($shopItem);
    }
}