<?php

/**
 * 赛车商城测试
 */

namespace Test\Shop;

use Game\Constant\ClientErrorCode;
use Game\Logic\Shop\ShopCarLogic;
use Game\Model\MoneyModel;
use Test\TestBase;

class TestShopCar extends TestBase
{
    use ShopCarLogic;

    public function getPlayerId(): int
    {
        return 288899155767734504;
    }

    public function startTest()
    {
        //测试买车
        //道具不存在
        $id = 1;
        $couponId = 0;
        $params = "";
        var_dump(ClientErrorCode::SHOP_CAR_ITEM_NOT_FOUND == $this->buyShopCarItem($id, $couponId, $params));

        //类型不对 不能购买
        $id = 20004;
        var_dump(ClientErrorCode::SHOP_CAR_ITEM_CAN_NOT_BUY == $this->buyShopCarItem($id, $couponId, $params));

        //钱不够
        $id = 20001;
        var_dump(ClientErrorCode::MONEY_GOLD_NOT_ENOUGH == $this->buyShopCarItem($id, $couponId, $params));

        $this->addMoney(MoneyModel::TYPE_GOLD, 9999);

        //正常购买
        var_dump(ClientErrorCode::MONEY_GOLD_NOT_ENOUGH == $this->buyShopCarItem($id, $couponId, $params));
    }
}
