<?php

namespace Test\SeasonStatistics;

use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Data\SeasonStatisticsData;
use Game\Logic\MapStatisticsLogic;
use Game\Logic\SeasonStatisticsLogic;
use Game\Model\MapStatisticsModel;
use Game\Protobuf\SettlementParameter;
use Test\TestBase;

class TestStatistics extends TestBase
{
    use SeasonStatisticsLogic;
    use MapStatisticsLogic;

    public function getPlayerId(): int
    {
        return 288843269665792570;
    }

    public function startTest()
    {
//        $data = $this->getSeasonStatistics();
//        var_dump($data);
        $parameter = new SettlementParameter();
        $parameter->setJamNum(1);
        $info = $this->updateMapStatistics(
            $this->getPlayerId(),
            1,
            0,
            2,
            $parameter,
            1
        );
        var_dump($info->serializeToJsonString());
        /**
         * @var MapStatisticsModel $mapStatisticsModel
         */
        $mapStatisticsModel = ModelManager::getInstance()->getModel(ModelTypeDefine::MAP_STATISTICS);
        $mapStatisticsModel->clearMapStatisticsDataByTitleType(2);
    }
}
