<?php

namespace Test\Pvp;

use Framework\DB\Handler\MatchingDBHandler;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Lib\Utils;
use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateRankingTest;
use Game\Constant\DBTableDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\Pvp\PvpLogic;

use Game\Protobuf\GMJoinMatch;

use Game\Protobuf\RoomPlayers;

use Game\Protobuf\TeamRankingMatchParam;
use Test\TestBase;

class TestJoinMatching extends TestBase
{
    use MatchingDBHandler;
    use PlayerDBHandler;
    use TemplateHelp;
    use PvpLogic;

    private const SLEEP_TIME = 3; //每次发送数据,间隔时间
    private const NUM = 100;         //每次发送人数
    private const SERVER_ID = 4;
    private const MAP_ID = 2;

    private int $index = 0;

    private int $JoinIndex = 0;

    public function getPlayerId(): int
    {
        return 288800264169915838;
    }

    public function getJoinId() : int
    {
        return ( 1000000000 + $this->JoinIndex++);
    }

    public function startTest()
    {
        //需要先关闭CLI,防止自动处理匹配结果
        //发送匹配数据,需要注释处理匹配结果
        $this->startMakeJoinMatch();

        //处理匹配结果,先注释发送匹配数据
        $this->dealMatchResult();
    }

    private function startMakeJoinMatch()
    {
        $player1Config = $this->getTitle(TemplateDefine::TYPE_RANKING_TEST, 1);
        $player2Config = $this->getTitle(TemplateDefine::TYPE_RANKING_TEST, 2);
        $player3Config = $this->getTitle(TemplateDefine::TYPE_RANKING_TEST, 3);
        $maxNum = max(count($player1Config), count($player2Config), count($player3Config));
        while ($maxNum > 0) {
            if ($this->index % self::NUM == 0) {
                sleep(self::SLEEP_TIME);
            }
            $this->makeJoinMatchMessage(array_shift($player1Config));
            $this->makeJoinMatchMessage(array_shift($player2Config));
            $this->makeJoinMatchMessage(array_shift($player3Config));
            $maxNum--;
            $this->index++;
        }
    }

    private function CreateRoomPlayer(int $playerId): RoomPlayers
    {
        $obj =  new RoomPlayers();
        $obj->setPlayerID($playerId);
        $obj->setCarShow("carTest");
        $obj->setPlayerShow("playerTest");
        return $obj;
    }

    private function makeJoinMatchMessage(?array $data)
    {
        if (is_null($data)) {
            return;
        }
        $playerId = 0;
        $playerInfo = [];
        $matchParam = new TeamRankingMatchParam();
        if ($data[TemplateRankingTest::Position1PlayerId] != 0) {
            $playerInfo [] = $this->CreateRoomPlayer($data[TemplateRankingTest::Position1PlayerId]);
            if ($playerId == 0) {
                $playerId = $data[TemplateRankingTest::Position1PlayerId];
            }
            $matchParam->setPosition1PlayerId($data[TemplateRankingTest::Position1PlayerId]);
            $matchParam->setPosition1Ratio($data[TemplateRankingTest::Position1Ratio]);
        }
        if ($data[TemplateRankingTest::Position2PlayerId] != 0) {
            $playerInfo [] = $this->CreateRoomPlayer($data[TemplateRankingTest::Position2PlayerId]);
            if ($playerId == 0) {
                $playerId = $data[TemplateRankingTest::Position2PlayerId];
            }
            $matchParam->setPosition2PlayerId($data[TemplateRankingTest::Position2PlayerId]);
            $matchParam->setPosition2Ratio($data[TemplateRankingTest::Position2Ratio]);
        }
        if ($data[TemplateRankingTest::Position3PlayerId] != 0) {
            $playerInfo [] = $this->CreateRoomPlayer($data[TemplateRankingTest::Position3PlayerId]);
            if ($playerId == 0) {
                $playerId = $data[TemplateRankingTest::Position3PlayerId];
            }
            $matchParam->setPosition3PlayerId($data[TemplateRankingTest::Position3PlayerId]);
            $matchParam->setPosition3Ratio($data[TemplateRankingTest::Position3Ratio]);
        }
        [$maxTime, $lvRange, $matchTimeProto] = $this->getRankingConfig($data[TemplateRankingTest::Level]);
        $matchParam->setLevel($data[TemplateRankingTest::Level]);
        $matchParam->setLevelRange($lvRange);
        $matchParam->setScore($data[TemplateRankingTest::Score]);
        $matchParam->setMatchTimeScore($matchTimeProto);

        $match = new GMJoinMatch();
        $match->setPlayerID($playerId);
        $match->setServerID(self::SERVER_ID);
        $match->setJoinID($this->getJoinId());
        $match->setMapID(self::MAP_ID);
        $match->setMatchType(GameConstantDefine::MATCH_MODE_TEAM_PAI_WEI);
        $match->setPlayer($playerInfo);
        $match->setMatchParam(base64_encode($matchParam->serializeToString()));
        $this->sendJoinMatchingPacket($match);
    }

    //处理匹配结果
    private function dealMatchResult()
    {
        $result = array();
        $this->searchMultiQueue(
            DBTableDefine::TABLE_PVP,
            self::SERVER_ID,
            0,
            -1,
            $result
        );

        echo "match team num:".count($result);
        echo "<br>\n";

        //删除数据
        $this->delMultiQueue(
            DBTableDefine::TABLE_PVP,
            self::SERVER_ID,
            count($result),
            1
        );
    }
}
