<?php

namespace Test\Proficiency;

use Game\Constant\ClientErrorCode;
use Game\Logic\CarLogic;
use Game\Logic\ProficiencyLogic;
use Test\TestBase;

class TestProficiency extends TestBase
{
    use ProficiencyLogic;
    use CarLogic;

    public function getPlayerId(): int
    {
        return 288898618895854583;
    }

    public function startTest()
    {
        $carId = 1004;
        //检查有没有车
        $car = $this->searchCarDataByCarID($carId);
        if (is_null($car)) {
            $this->systemGainCar($carId, 1, 0);
        }

        //获取总活跃度信息
        var_dump($this->getTotalProficiencyData());

        //给车升级
        $this->addCarProficiency($carId, 500, false);

        //获取总活跃度信息
        var_dump($this->getTotalProficiencyData());

        //领取总活跃度当个奖励
        $code = 0;
        //奖励不存在
        $this->getTotalProficiencySingleReward(99999, false, $code);
        var_dump(ClientErrorCode::PROFICIENCY_TOTAL_REWARD_NOT_FOUND === $code);

        //等级不足
        $this->getTotalProficiencySingleReward(10, false, $code);
        var_dump(ClientErrorCode::PROFICIENCY_TOTAL_REWARD_LEVEL_NOT_ENOUGH === $code);

        //领取高级奖励
        $this->getTotalProficiencySingleReward(1, true, $code);
        var_dump(ClientErrorCode::PROFICIENCY_TOTAL_REWARD_NOT_OPEN_EXPERT === $code);

        //正常领取
        $this->getTotalProficiencySingleReward(1, false, $code);
        var_dump(ClientErrorCode::CLIENT_SUCCESS === $code);

        //重复领取
        $this->getTotalProficiencySingleReward(1, false, $code);
        var_dump(ClientErrorCode::PROFICIENCY_TOTAL_REWARD_ALREADY_GET === $code);

        //开通高级
        $this->openTotalProficiencyExpertFlag();

        //一键领取
        $this->getTotalProficiencyAllReward();

        //获取总活跃度信息
        var_dump($this->getTotalProficiencyData());

        //领取赛车奖励
        //赛车不存在
        $this->getCarSingleProficiencyReward(1, 1, $code);
        var_dump(ClientErrorCode::PROFICIENCY_REWARD_CAR_NOT_FOUND === $code);

        //奖励不存在
        $this->getCarSingleProficiencyReward($carId, 99999, $code);
        var_dump(ClientErrorCode::PROFICIENCY_REWARD_CAR_REWARD_NOT_FOUND === $code);

        //等级不足
        $this->getCarSingleProficiencyReward($carId, 10, $code);
        var_dump(ClientErrorCode::PROFICIENCY_REWARD_CAR_LEVEL_NOT_ENOUGH === $code);

        //正常领取
        $this->getCarSingleProficiencyReward($carId, 1, $code);
        var_dump(ClientErrorCode::CLIENT_SUCCESS === $code);

        //重复领取
        $this->getCarSingleProficiencyReward($carId, 1, $code);
        var_dump(ClientErrorCode::PROFICIENCY_REWARD_CAR_ALREADY_GET === $code);

        //一键领取
        $this->getCarAllProficiencyReward($carId, $code);

        //查询车信息
        var_dump($this->searchCarDataByCarID($carId));
    }
}
