<?php

namespace Test\PVE;

use Game\Data\PVE\LevelData;
use Game\Logic\PVE\PveSettlementLogic;
use Game\Protobuf\TaleTarget;
use Test\TestBase;

class TestPve extends TestBase
{
    use PveSettlementLogic;

    public function getPlayerId(): int
    {
        return 1111;
    }

    public function startTest()
    {
        //驾照关卡
        $levelId = 30011;
        $chapterId = 1;
        $code = $this->checkPveLevel($levelId, $chapterId);
        var_dump($code);

        //开启初始关卡
        $this->sendChapterLevelMessage(1);
        //获取驾照关卡
        $levelData = new LevelData($this->getPlayerId());
        $levelData->searchDB($levelId);
        //通关检查
        $taleTarget = new TaleTarget();
        $taleTarget->setCostTime(73000);
        $taleTarget->setRank(1);
        $this->checkCompleteLevel($levelData, $taleTarget);
        $levelData->searchDB($levelId);
        var_dump($levelData);
    }
}
