<?php

namespace Test\Money;

use Game\Logic\MoneyLogic;
use Game\Model\MoneyModel;
use Test\TestBase;

class TestMoney extends TestBase
{
    use MoneyLogic;

    public function getPlayerId(): int
    {
        return 288399672520286915;
    }

    public function startTest()
    {
        $this->addMoney(MoneyModel::TYPE_GOLD, 123);
        $gold = $this->getMoney(MoneyModel::TYPE_GOLD);

        $this->addMoneyList(
            array(
                MoneyModel::TYPE_TICKETS => 456,
                MoneyModel::TYPE_DIAMOND => 789
            )
        );
        $tickets = $this->getMoney(MoneyModel::TYPE_TICKETS);
        $diamond = $this->getMoney(MoneyModel::TYPE_DIAMOND);

        $this->subMoney(MoneyModel::TYPE_TICKETS, 100);
        $tickets = $this->getMoney(MoneyModel::TYPE_TICKETS);

        $this->addMoneyList(
            array(
               MoneyModel::TYPE_GOLD => 10,
               MoneyModel::TYPE_DIAMOND => 10
            )
        );

        $gold = $this->getMoney(MoneyModel::TYPE_GOLD);
        $diamond = $this->getMoney(MoneyModel::TYPE_DIAMOND);
    }
}
