<?php

namespace Test\Mode;

use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Data\RaceResultData;
use Game\Model\Pvp\Mode\SinglePracticeModel;
use Test\TestBase;

class TestMode extends TestBase
{

    public function getPlayerId(): int
    {
        return 288471922468086731;
    }

    public function startTest()
    {

        $p1 = [
            '_playerId' => 288471922468086731,
            '_carId' => 1001,
            '_rank' => 0,
            '_costTime' => 155880,
            '_helpNum' => 0,
            '_jamNum' => 0,
            '_helpIcon' => false,
            '_jamIcon' => false,
            '_raceIcon' => false,
            '_mvpIcon' => false,
            '_isWin' => false,
        ];
        $p2 =  [
        '_playerId' => 100,
        '_carId' => 1001,
        '_rank' => 0,
        '_costTime' => 0,
        '_helpNum' => 0,
        '_jamNum' => 0,
        '_helpIcon' => false,
        '_jamIcon' => false,
        '_raceIcon' => false,
        '_mvpIcon' => false,
        '_isWin' => false,
        ];
        $po1 = new RaceResultData();
        $po1->_playerId = $p1['_playerId'];
        $po1->_carId = $p1['_carId'];
        $po1->_rank = $p1['_rank'];
        $po1->_costTime = $p1['_costTime'];
        $po1->_helpNum = $p1['_helpNum'];
        $po1->_jamNum = $p1['_jamNum'];
        $po1->_raceIcon = $p1['_raceIcon'];
        $po1->_mvpIcon = $p1['_mvpIcon'];
        $po1->_isWin = $p1['_isWin'];

        $po2 = new RaceResultData();
        $po2->_playerId = $p2['_playerId'];
        $po2->_carId = $p2['_carId'];
        $po2->_rank  = $p2['_rank'];
        $po2->_costTime = $p2['_costTime'];
        $po2->_helpNum = $p2['_helpNum'];
        $po2->_jamNum = $p2['_jamNum'];
        $po2->_raceIcon = $p2['_raceIcon'];
        $po2->_mvpIcon = $p2['_mvpIcon'];
        $po2->_isWin = $p2['_isWin'];

        $receResultList = [
            288471922468086731 => $po1,
            100 =>  $po2,
            0=> [
                0 => [],
                1 => [],
                2 => [
                    0 => 288471922468086731,
                    1 => 1001
                ]
            ],
            1=>1,
            2=>0,
        ];
//        $pra = new SinglePracticeModel();
//        $pra->randMap();
//        $pra->getPracticeRandMap();
        /////////////////////////////////////////////////////////////////
        $model = ModelManager::getInstance()->getModel(ModelTypeDefine::MODE_MAP[1]);
        if(!$model->matchSettlement(288471922468086731, $receResultList)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                "[mode] pvp single match settlement error!"
            );
            echo 111;
        }
        /////////////////////////////////////////////////////////////////

    }

}

