<?php

namespace Test\Mail;

use Framework\Lib\Utils;
use Framework\MVC\ModelManager;
use Framework\Logic\TimerLogic;
use Game\Constant\ModelTypeDefine;
use Test\TestBase;
use Game\Model\MailModel;
use Game\Logic\MailLogic;

class TestMail extends TestBase
{
    use MailLogic;
    use TimerLogic;

    public function getPlayerId(): int
    {
        return 288507119721167639;
    }

    public function startTest()
    {
        $tplId = 1;
        $receiveTime = Utils::getServerTimestamp();
        $expireTime = $receiveTime - 30 * 86400 + 2;
        /**
         * @var MailModel $mail
         */
        $mail = ModelManager::getInstance()->getModel(ModelTypeDefine::MAIL);

        $allMail = $mail->getAllMailUid(0, -1);
        var_dump($allMail);

        $mail->createMail($tplId, $receiveTime);

        $allMail = $mail->getAllMailUid(0, -1);
        var_dump($allMail);

        $uid = array_keys($allMail)[0];

        //test mailLogic
        $this->getAllMailByIndex(0, -1);

        $this->singleMailRead($uid);

        $this->singleMailGet($uid);

        $this->singleMailDel($uid);

        $this->createPlayerMail($tplId, $receiveTime);

        $this->allMailGetEnclosure();

        $this->allMailDel();

        //测试过期删除
        $mail->createMail($tplId, $expireTime);

        $allMail = $mail->getAllMailUid(0, -1);
        var_dump($allMail);

        echo "test expire start". "<br>";

        $i = 3;
        while ($i > 0) {
            $this->timerHeartBeat($receiveTime);
            $allMail = $mail->getAllMailUid(0, -1);
            var_dump($allMail);
            sleep(1);
            $i--;
        }

        echo "test expire end". "<br>";
    }
}
