<?php
/**
 *
 * @date 2022/5/17/017
 * @author JZW
 **/
namespace Test\GameLevel;

use Framework\Logic\TemplateHelp;
use Game\Constant\TemplateDefine;
use Game\Logic\PVE\CareerLogic;
use Game\Logic\PVE\PveTargetLogic;
use Game\Protobuf\MatchOperation;
use Game\Protobuf\TaleTarget;
use Test\TestBase;

class TestGameLevel extends TestBase
{
    use TemplateHelp;
    use CareerLogic;
    use PveTargetLogic;

    public function getPlayerId(): int
    {
        return 288881902899380674;
    }

    public function startTest()
    {
        $levelId = 10005;
        $taleTarget = new TaleTarget();
        $taleTarget->setCostTime(18971);
        $levelConfig = $this->getTitle(TemplateDefine::TYPE_TALE, $levelId);
        $compTarget = [1,1,1];
        $this->checkCompleteCareerLevel(
            $levelId,
            $taleTarget,
            $levelConfig,
            $compTarget
        );
        $matchOperation = new MatchOperation();
        $taleTarget->setLastTime(6388);
        $compTarget = $this->getTargetCompleteInfo(
            $levelConfig,
            $taleTarget,
            $matchOperation
        );
        var_dump($compTarget);
    }
}