<?php

namespace Test\DrivingLicense;

use Game\Data\PVE\DrivingLicenseData;
use Game\Data\PVE\LevelData;
use Game\Logic\PVE\DrivingLicenseLogic;
use Game\Logic\PVE\PveSettlementLogic;
use Game\Protobuf\MatchOperation;
use Game\Protobuf\PlayerMark;
use Game\Protobuf\TaleTarget;
use Test\TestBase;

class TestDrivingLicense extends TestBase
{
    use DrivingLicenseLogic;
    use PveSettlementLogic;

    public function getPlayerId(): int
    {
        return 1111;
    }

    public function startTest()
    {
        //获取驾照信息
        $drivingLicenseData = new DrivingLicenseData($this->getPlayerId());
        $drivingLicenseData->searchDB();
        var_dump($drivingLicenseData);

        //开启初始关卡
        $this->sendChapterLevelMessage(1);
        //获取驾照关卡
        $chapterId = 0;
        $chapterData = $this->getDrivingLicenseChapter($chapterId);
        var_dump($chapterData);

        //通关条件
        $taleTarget = new TaleTarget();
        $taleTarget->setCostTime(10000);
        $taleTarget->setRank(1);
        //通关第一关
        $levelId = 30011;
        $levelData = new LevelData($this->getPlayerId());
        $levelData->searchDB($levelId);
        $matchOption = new MatchOperation();
        $matchOption->setSpray1Num(10);
        $playerMark = new PlayerMark();
        $playerMark->setRank(1);
        $this->checkCompleteLevel($levelData, $taleTarget, $matchOption, $playerMark);
        $levelData->searchDB($levelId);
        var_dump($levelData);

        //查看驾照
        $drivingLicenseData->searchDB();
        var_dump($drivingLicenseData);

    }
}
