<?php

namespace Test\Common;

use Framework\Lib\Utils;
use Framework\Logic\CommonTimerLogic;
use Game\Constant\ModelTypeDefine;
use Test\TestBase;

class TestTimer extends TestBase
{
    use CommonTimerLogic;

    public function getPlayerId(): int
    {
        return 0;
    }

    public function startTest()
    {
        $modelType = ModelTypeDefine::ACCOUNT;
        $expireTime = Utils::getServerTimestamp() - 10;
        $titleId = 1;

        $this->addCommonTimer($modelType,$titleId, $expireTime);
        $this->commonTimerHeartBeat(Utils::getServerTimestamp());
        $this->addCommonTimer($modelType,$titleId, $expireTime);
        $this->delCommonTimer($modelType,$titleId);
    }
}
