<?php

/**
 * TestPacketCache.php
 * 文件描述
 * Created On 2022/2/16
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Test\Assist;

use Framework\Logic\PacketCacheLogic;
use Game\Protobuf\GainMoneySingle;
use Game\Protobuf\PacketId;
use Game\Protobuf\SyncChangeMoney;
use Test\TestBase;

class TestPacketCache extends TestBase
{
    use PacketCacheLogic;

    public function getPlayerId(): int
    {
        return 288417080025051469;
    }

    public function startTest()
    {
        for ($i = 0; $i < 20; $i++) {
            $syncMessage = array();
            $changeMoney = new GainMoneySingle();
            $changeMoney->setId(1);
            $changeMoney->setNum(100 + $i);
            array_push($syncMessage, $changeMoney);

            $sendMessage = new SyncChangeMoney();
            $sendMessage->setMoney($syncMessage);
            $this->addPacket(PacketId::Sync_Change_Money, $sendMessage);
        }
    }
}
