<?php

namespace Test\Account;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Lib\Utils;
use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\DBTableDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\AccountLogic;
use Game\Logic\MailLogic;
use Game\Model\AccountModel;
use Test\TestBase;

class TestAccount extends TestBase
{
    use AccountLogic;
    use PlayerDBHandler;
    use MailLogic;

    public function getPlayerId(): int
    {
        return 123456;
    }

    public function startTest()
    {
//        $clothArr = array();
//        $clothArr['HairID'] = 1;
//        $clothArr['UpClothID'] = 3;
//        $clothArr['DownClothID'] = 3;
//        $clothArr['ShoesID'] = 4;
//        $clothArr['SuitID'] = 5;
//        $sex = 1;
//        $acc = new AccountModel();
//        $acc->setPlayerId($this->getPlayerId());
//        $acc->saveDress($sex, $clothArr);

        // 发送给玩家邮件
        // 发送邮件
        $mailTplId = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Week_Gift_MAIL_ID,
            TemplateConst::ConstNum);
        for ($num = 1; $num <= 200; $num ++) {
            $this->createPlayerMail($mailTplId, Utils::getServerTimestamp(), [100001 => 1]);
        }

//         增加道具车
        $this->gmGainItem(399999, 1);

        $this->gmGainItem(100001, 100000000);
        $this->gmGainItem(100002, 100000000);
        $this->gmGainItem(100003, 100000000);

        $this->gmGainItem(300010, 100000);
//
        $this->gmGainItem(300011, 10000);
        $this->gmGainItem(300012, 10000);
        $this->gmGainItem(300013, 10000);
//
//        // 增加服装
        $this->gmGainItem(710015, 1);
        $this->gmGainItem(710010, 1);
        $this->gmGainItem(700005, 1);
        $this->gmGainItem(700005, 1);

        // 增加很多好友
        for($id = 541697069845; $id <= 541697069944; $id ++) {
            $this->updateTitle(DBTableDefine::TABLE_FRIENDS, $id, 0, [$this->getPlayerId() => json_encode(
                [
                    "createTime"  => 1696938555,
                    "remark"=> "",
                    "intimacy"=> 0,
                    "intimacyIcon"=> 0,
                    "matchNum"=> 0,
                    "keepFire"=> false,
                    "cdTime"=> 0,
                    "intimacyCreateTime"=> 0,
                    "intimacyId"=> 0
                ]
            )]);
            $this->updateTitle(DBTableDefine::TABLE_FRIENDS, 123456, 0, [$id=>json_encode([
                "createTime"  => 1696938555,
                "remark"=> "",
                "intimacy"=> 0,
                "intimacyIcon"=> 0,
                "matchNum"=> 0,
                "keepFire"=> false,
                "cdTime"=> 0,
                "intimacyCreateTime"=> 0,
                "intimacyId"=> 0
            ])]);

        }

    }
}
